% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmtsne.R
\name{mmtsneP}
\alias{mmtsneP}
\title{Multiple maps t-SNE with symmetric probability matrix}
\usage{
mmtsneP(P, no_maps, no_dims = 2, max_iter = 500, momentum = 0.5,
  final_momentum = 0.8, mom_switch_iter = 250, eps = 1e-07)
}
\arguments{
\item{P}{An \eqn{N x N} symmetric joint probability distribution matrix.
These can be constructed from an \eqn{N} by \eqn{D} matrix with
\code{\link{x2p}} and \code{\link{p2sp}}. Alternatively, the wrapper
function \code{\link{mmtsne}} will wrap the matrix construction and
multiple maps t-SNE model estimation into a single step.}

\item{no_maps}{The number of maps (positive whole number) to be estimated.}

\item{no_dims}{The number of dimensions per map. Typical values are 2 or 3.}

\item{max_iter}{The number of iterations to run.}

\item{momentum}{Constant scaling factor for update momentum in gradient
descent algorithm.}

\item{final_momentum}{Constant scaling factor for update momentum in gradient
descent algorithm after the momentum switch point.}

\item{mom_switch_iter}{The iteration at which momentum switches from
\code{momentum} to \code{final_momentum}.}

\item{eps}{A small positive value near zero.}
}
\value{
A list that includes the following objects:
   \describe{
   \item{Y}{An \code{N x no_dims x no_maps} array of predicted coordinates.}
   \item{weights}{An \code{N x no_maps} matrix of unscaled weights. A high
       weight on entry \eqn{i, j} indicates a greater contribution of point
       \eqn{i} on map \eqn{j}.}
   \item{proportions}{An \code{N x no_maps} matrix of scaled weights. A high
       weight on entry \eqn{i, j} indicates a greater contribution of point
       \eqn{i} on map \eqn{j}.}
   }
}
\description{
\code{mmtsneP} estimates a multiple maps t-distributed stochastic neighbor
   embedding (multiple maps t-SNE) model.
}
\details{
This code is an almost direct port of the original multiple maps t-SNE Matlab
   code by van der Maaten and Hinton (2012). \code{mmtsne} estimates a
   multidimensional array of \code{N x no_dims x no_maps}. Each map is an
   \code{N x no_dims} matrix of estimated t-SNE coordinates. When
   \code{no_maps=1}, multiple maps t-SNE reduces to standard t-SNE.
}
\examples{
# Load the iris dataset
data("iris")

# Produce a symmetric joint probability matrix
prob_matrix <- p2sp(x2p(as.matrix(iris[,1:4])))

# Estimate a mmtsne model with 2 maps, 2 dimensions each
model <- mmtsneP(prob_matrix, no_maps=2, max_iter=100)

# Plot the results side-by-side for inspection
# Points scaled by map proportion weights plus constant factor
par(mfrow=c(1,2))
plot(model$Y[,,1], col=iris$Species, cex=model$proportions[,1] + 0.2)
plot(model$Y[,,2], col=iris$Species, cex=model$proportions[,2] + 0.2)
par(mfrow=c(1,1))

}
\references{
L.J.P. van der Maaten and G.E. Hinton. ``Visualizing Non-Metric
   Similarities in Multiple Maps.'' \emph{Machine Learning} 87(1):33-55,
   2012.
   \href{https://lvdmaaten.github.io/publications/papers/MachLearn_2012.pdf}{PDF.}
}
