% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixNormal-dist.R
\name{MatrixNormal-dist}
\alias{MatrixNormal-dist}
\alias{dMNorm}
\alias{rMNorm}
\alias{MatrixNormal}
\title{The Matrix-Normal distribution.}
\usage{
dMNorm(X, Lambda, SigmaR, SigmaC, log = FALSE)

rMNorm(n, Lambda, SigmaR, SigmaC)
}
\arguments{
\item{X}{Argument to the density function.  Either a \verb{p x q} matrix or a \verb{p x q x n} array.}

\item{Lambda}{Mean parameter.  Either a \verb{p x q} matrix or a \verb{p x q x n} array.}

\item{SigmaR}{Between-row covariance matrix.  Either a \verb{p x p} matrix or a \verb{p x p x n} array.}

\item{SigmaC}{Between-column covariance matrix  Either a \verb{q x q} matrix or a \verb{q x q x n} array.}

\item{log}{Logical; whether or not to compute the log-density.}

\item{n}{Integer number of random samples to generate.}
}
\value{
A vector length \code{n} for density evaluation, or an array of size \verb{p x q x n} for random sampling.
}
\description{
Density and random sampling for the Matrix-Normal distribution.
}
\details{
The Matrix-Normal distribution \eqn{\boldsymbol{X} \sim \textrm{Matrix-Normal}(\boldsymbol{\Lambda}, \boldsymbol{\Sigma}_R, \boldsymbol{\Sigma}_C)}{X ~ Matrix-Normal(\Lambda, \Sigma_R, \Sigma_C)} on the random matrix \eqn{\boldsymbol{X}_{p \times q}}{X_(p x q)} is defined as
\deqn{
\textrm{vec}(\boldsymbol{X}) \sim \mathcal{N}(\textrm{vec}(\boldsymbol{\Lambda}), \boldsymbol{\Sigma}_C \otimes \boldsymbol{\Sigma}_R),
}{
vec(X) ~ N(vec(\Lambda), \Sigma_C \%x\% \Sigma_R),
}
where \eqn{\textrm{vec}(\boldsymbol{X})}{vec(X)} is a vector stacking the columns of \eqn{\boldsymbol{X}}{X}, and \eqn{\boldsymbol{\Sigma}_C \otimes \boldsymbol{\Sigma}_R}{\Sigma_C \%x\% \Sigma_R} denotes the Kronecker product.
}
\examples{
# problem dimensions
p <- 4
q <- 2
n <- 10 # number of observations
# parameter values
Lambda <- matrix(rnorm(p*q),p,q) # mean matrix
# row-wise variance matrix (positive definite)
SigmaR <- crossprod(matrix(rnorm(p*p), p, p))
SigmaC <- rwish(n, Psi = diag(q), nu = q + 1) # column-wise variance (vectorized)

# random sample
X <- rMNorm(n, Lambda = Lambda, SigmaR = SigmaR, SigmaC = SigmaC)

# log-density at each sampled value
dMNorm(X, Lambda = Lambda, SigmaR = SigmaR, SigmaC = SigmaC, log = TRUE)
}
