% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobilityIndexFunctions.R
\name{getMobilityIndices}
\alias{getMobilityIndices}
\title{Calculates Mobility Indices at Two Points in Time}
\usage{
getMobilityIndices(
  dat,
  col_x,
  col_y,
  type,
  indices = "all",
  num_ranks,
  exclude_value,
  bounds,
  rerank_exclude_value,
  strict = TRUE,
  intervals = FALSE,
  interval_pct = 0.95,
  bootstrap_iter = 100
)
}
\arguments{
\item{dat}{a dataframe with an "id" column}

\item{col_x}{a character string denoting the first column to be used in the index calculation}

\item{col_y}{a character string denoting the second column to be used in the index calculation}

\item{type}{a character string indicating the type of ranking;
accepts 'relative', 'mixed', and 'absolute'}

\item{indices}{a vector of character strings indicating which mobility indices are desired;
currently support 'prais_bibby', 'average_movement', 'wgm', and 'origin_specific'.
The default value is 'all'.}

\item{num_ranks}{an integer specifying the number of ranks for a relative or mixed ranking}

\item{exclude_value}{a single numeric value that is excluded in calculating the transition matrix;
see the rerank_exclude_value parameter to specify how the exclude value is handled}

\item{bounds}{a sequence of numeric bounds for defining absolute ranks}

\item{rerank_exclude_value}{a character string indicating how the exclude value is handled when present; accepts
'as_new_rank', 'as_existing_rank', and 'exclude'}

\item{strict}{logical. If TRUE, indices are calculated from the given values. If FALSE,
indices are calculated by jittering the values to ensure uniqueness of bounds of ranks.
Only used with relative and mixed types. The default value is TRUE.}

\item{intervals}{logical. If TRUE, will calculate bootstrapped confidence intervals
using the percentile method. The default value is FALSE.}

\item{interval_pct}{a number between zero and one indicating the size of the bootstrapped intervals.
The default value is 0.95.}

\item{bootstrap_iter}{the number of bootstrap iterations used to estimate intervals.
The default value is 100.}
}
\value{
Returns a named vector containing the desired index values
}
\description{
Calculates mobility indices from two columns in dataset. Supports Prais-Bibby,
Absolute Movement, Origin Specific, and Weighted Group Mobility indices and relative, mixed,
and absolute types of rankings in the calculation these indices.
}
\examples{
data(incomeMobility)
getMobilityIndices(dat = incomeMobility,
                   col_x = 't0',
                   col_y = 't2',
                   type = 'relative',
                   num_ranks = 5)
}
