% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_plotting.R
\name{corr_plots}
\alias{corr_plots}
\title{Plots correlation matrix of original and simulated data}
\usage{
corr_plots(
  Modgo_obj,
  sim_dataset = 1,
  variables = colnames(Modgo_obj[["simulated_data"]][[1]])
)
}
\arguments{
\item{Modgo_obj}{An object returned by \code{\link[modgo]{modgo}}.}

\item{sim_dataset}{Number indicating the simulated dataset in 
\code{Modgo_obj} to be used in plots.}

\item{variables}{A character vector indicating the columns in the data to 
be used in plots.}
}
\value{
A patchwork object created by \code{\link[patchwork]{wrap_plots}}
depicting correlation matrices.
}
\description{
Produces a graphical display of the correlation matrix of the original 
dataset, a  single simulated  dataset and also of the  average of the 
correlation matrices across all simulations for an object returned by 
\code{\link[modgo]{modgo}}.
}
\examples{

data("Cleveland",package="modgo")

test_modgo <- modgo(data = Cleveland,
     bin_variables = c("CAD","HighFastBloodSugar","Sex","ExInducedAngina"),
     categ_variables =c("Chestpaintype"))

corr_plots(test_modgo)

}
\author{
Francisco M. Ojeda, George Koliopanos
}
