% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_transformation_gener.R
\name{general_transform_inv}
\alias{general_transform_inv}
\title{Inverse gldex transformation}
\usage{
general_transform_inv(x, data = NULL, n_samples, lmbds)
}
\arguments{
\item{x}{a vector of z values}

\item{data}{a data frame with original variables.}

\item{n_samples}{number of samples you need to produce.}

\item{lmbds}{a vector with generalized lambdas values}
}
\value{
A numeric vector with inverse transformed values
}
\description{
Inverse transforms z values of a vector to simulated values driven by
the original dataset using Generalized Lambda and Generalized Poisson 
percentile functions
}
\examples{
\donttest{
data("Cleveland",package="modgo")
test_rank <- rbi_normal_transform(Cleveland[,1])
test_generalized_lmbds <- generalizedMatrix(Cleveland, 
                  bin_variables = c("Sex", "HighFastBloodSugar", "CAD"))
test_inv_rank <- general_transform_inv(x = test_rank,
                  data = Cleveland[,1],
                  n_samples = 100,
                  lmbds = test_generalized_lmbds[,1])
}


}
\author{
Andreas Ziegler, Francisco M. Ojeda, George Koliopanos
}
\keyword{Generalized}
\keyword{Inverse}
\keyword{transformation}
