% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitNetwork.R
\name{fitNetwork}
\alias{fitNetwork}
\title{Fit cross-sectional and idiographic moderated network models}
\usage{
fitNetwork(
  data,
  moderators = NULL,
  type = "gaussian",
  lags = NULL,
  seed = NULL,
  folds = 10,
  gamma = 0.5,
  which.lam = "min",
  rule = "OR",
  threshold = FALSE,
  scale = FALSE,
  std = TRUE,
  center = TRUE,
  covariates = NULL,
  verbose = FALSE,
  exogenous = TRUE,
  mval = NULL,
  residMat = "sigma",
  medges = 1,
  pcor = FALSE,
  maxiter = 100,
  getLL = TRUE,
  saveMods = TRUE,
  binarize = FALSE,
  fitCoefs = FALSE,
  detrend = FALSE,
  beepno = NULL,
  dayno = NULL,
  ...
)
}
\arguments{
\item{data}{\code{n x k} dataframe or matrix.}

\item{moderators}{Numeric or character vector indicating which variables (if
any) to use as moderators.}

\item{type}{Primarily used to supply a variable selection object, such as
those created with \code{\link{varSelect}} or \code{\link{modSelect}}, or
to indicate that a variable selection method should be employed by setting
the value to \code{"varSelect"}. Currently doesn't support setting the
value to \code{"resample"}, although this will be implemented in the
future. Alternatively, this can be used to specify the type of variable for
each node. In this case it should be either a single value --
\code{"gaussian"} or \code{"binomial"} -- or can be a vector of length
\code{k} to specify which of those two types apply to each variable. These
dictate which family to use for the call to
\code{\link[stats:glm]{stats::glm}}. Cannot use binomial models for SUR
networks.}

\item{lags}{Logical or numeric, to indicate whether to fit a SUR model or
not. Set to \code{TRUE} or 1 for a SUR model fit to temporal data for a
single subject.}

\item{seed}{Only useful if \code{type = "varSelect"}, and if the
\code{varSeed} argument is not specified in the \code{...}}

\item{folds}{Can be used to specify the number of folds in cross-validation
when \code{type = "varSelect"} and \code{criterion = "CV"}. Overwritten if
\code{nfolds} argument is provided.}

\item{gamma}{Only useful if \code{type = "varSelect"} and the criterion is
set to \code{"EBIC"}. This is the hyperparameter for the calculation of
EBIC.}

\item{which.lam}{Only useful if \code{criterion = "CV"}, or if a variable
selection object based on cross-validation is supplied for \code{type}.
Options include \code{"min"}, which uses the lambda value that minimizes
the objective function, or \code{"1se"} which uses the lambda value at 1
standard error above the value that minimizes the objective function.}

\item{rule}{Only applies to GGMs (including between-subjects networks) when a
threshold is supplied. The \code{"AND"} rule will only preserve edges when
both corresponding coefficients have p-values below the threshold, while
the \code{"OR"} rule will preserve an edge so long as one of the two
coefficients have a p-value below the supplied threshold.}

\item{threshold}{Determines whether to employ a p-value threshold on the
model. If \code{TRUE} then this defaults to .05. Not recommended, as
thresholds can be applied post-hoc through the plotting functions, or via
the \code{\link{net}} and \code{\link{netInts}} functions. Recommended to
leave as \code{FALSE}.}

\item{scale}{Determines whether to standardize all variables or not.}

\item{std}{Only applies to SUR networks. Logical. Provides input to the
\code{method} argument of the
\code{\link[systemfit:systemfit]{systemfit::systemfit}} function. If
\code{TRUE}, then the \code{method} will be \code{"SUR"}. If \code{FALSE},
then the \code{method} will be \code{"OLS"}. These two methods only differ
when constraints are applied. When a saturated model is fit, both methods
produce the same results.}

\item{center}{Determines whether to mean-center variables or not.}

\item{covariates}{Either a numeric value or character string -- this could
also be a vector -- to indicate which variables (if any) should be treated
as covariates in the model.}

\item{verbose}{Logical. Determines whether to return information about the
progress of the model fitting -- especially when variable selection is
employed -- as well as prints the amount of time it takes to fit the model
to the console.}

\item{exogenous}{Logical. Indicates whether moderator variables should be
treated as exogenous or not. If they are exogenous, they will not be
modeled as outcomes/nodes in the network. If the number of moderators
reaches \code{k - 1} or \code{k}, then \code{exogenous} will automatically
be \code{FALSE}.}

\item{mval}{Numeric value to set the moderator variable to when computing
model coefficients. Useful to create conditional networks -- i.e., those
whose values are conditioned on specific values of the moderator. Excellent
when the moderator is a categorical variable, or when it's desired to have
model estimates at +/- 1 SD around the mean of the moderator. These values
must be supplied explicitly. Can only specify a single value for a given
model.}

\item{residMat}{Character string indicating which type of residual covariance
matrix to compute for SUR models. Options include \code{"res", "dfres",
  "sigma"}. \code{"sigma"} uses the residual covariance matrix as computed by
the \code{systemfits} package. \code{"res"} and \code{"dfres"} compute the
matrix based directly on the residual values. \code{"dfres"} is the sample
estimator that uses \code{N - 1} in the denominator, while \code{"res"}
just uses \code{N}. Input for \code{\link{SURnet}} function.}

\item{medges}{Only relevant when \code{lags = 1} and \code{exogenous =
  FALSE}. Determines the linetype of moderated edges (corresponds to the lty
argument of \code{plot()}).}

\item{pcor}{Logical. Determines whether to operationalize the adjacency
matrix as the partial correlation matrix of the data, or to use nodewise
estimation. Only relevant for unmoderated networks.}

\item{maxiter}{See argument of \code{SURfit()} function.}

\item{getLL}{Logical. Determines whether to return log-likelihood statistics
with model results. Recommended to keep \code{TRUE}.}

\item{saveMods}{Logical. Determines whether to save the \code{fitobj} element
of the output, which contains the nodewise models, or the SUR model output
of \code{\link[systemfit:systemfit]{systemfit::systemfit}}.}

\item{binarize}{Logical. Determines whether to convert the output to a
binary, unweighted network. Only relevant for GGMs.}

\item{fitCoefs}{Determines whether to use the \code{\link{getFitCIs}}
function on the output. Not recommended to use. The downside is that this
will overwrite the \code{fitobj} element of the output which contains the
actual models. Better to leave this as \code{FALSE}, and then use the
\code{\link{getFitCIs}} function on the object separately.}

\item{detrend}{Logical. Determines whether to remove linear trends from time
series variables. Only applies to temporal networks.}

\item{beepno}{Character string or numeric value to indicate which variable
(if any) encodes the survey number within a single day. Must be used in
conjunction with \code{dayno} argument. Only relevant to temporal data.}

\item{dayno}{Character string or numeric value to indicate which variable (if
any) encodes the survey number within a single day. Must be used in
conjunction with \code{beepno} argument. Only relevant to temporal data.}

\item{...}{Additional arguments.}
}
\value{
A ggm or SUR network
}
\description{
The main function that ties everything together for both cross-sectional and
idiographic (temporal) network models, moderated or otherwise.
}
\details{
For GGMs, nodewise estimation is utilized to fit models to each node, and
then aggregate results into the final network. For temporal networks that
represent data for a single subject, SUR estimation based on feasible
generalized least squares (FGLS) is used. Also incorporates the variable
selection functions to integrate model selection and estimation. Nodewise
estimation is used for all GGMs, and SUR estimation is used for temporal
networks. See \code{systemfit} package for more information on the latter,
particularly via the \code{\link[systemfit:systemfit]{systemfit::systemfit}}
function.
}
\examples{
fit1 <- fitNetwork(ggmDat)

\donttest{
fit2 <- fitNetwork(ggmDat, 'M', type = 'varSelect', criterion = 'BIC')
}

fit3 <- fitNetwork(gvarDat, 'M', lags = 1)
}
