% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlGVAR.R
\name{mlGVARsim}
\alias{mlGVARsim}
\title{Main workhorse for simulating VAR and mlGVAR data}
\usage{
mlGVARsim(
  nTime = 50,
  nPerson = 10,
  nNode = 3,
  m = NULL,
  m2 = 0.25,
  m1 = 0.7,
  m0 = 1,
  lag = 1,
  thetaVar = NULL,
  mu_SD = NULL,
  init_beta_SD = NULL,
  fixedMuSD = 1,
  shrink_fixed = 0.9,
  propPos = 0.5,
  m1SD = 0.1,
  m2SD = 0.1,
  m1_range = NULL,
  m2_range = NULL,
  shrink_deviation = 0.9,
  getM = FALSE,
  contemporaneous = "wishart",
  GGMsparsity = 0.5,
  mcenter = TRUE,
  skew = FALSE,
  skewErr = FALSE,
  ordinal = FALSE,
  nLevels = 5,
  ordWithin = TRUE,
  minOrd = 3,
  thresholds = NULL,
  mseed = NULL,
  onlyNets = FALSE,
  modType = "none"
)
}
\arguments{
\item{nTime}{Numeric value. The number of timepoints to simulate for each
individual.}

\item{nPerson}{The number of subjects to create data for. Can set to \code{1}
to just simulate a single graphical VAR network.}

\item{nNode}{The number of nodes/variables to simulate. Does not include a
moderator if one is specified.}

\item{m}{Logical. If \code{TRUE}, then a moderator variable will be
simulated. Various options also available for highly specific moderator
specification: \code{"fixed", "random", "mixed1", "mixed2", "ar", "binary",
  "skewed", "random0", "ordinal"}.}

\item{m2}{Numeric. If \code{m2 >= 1}, then this will determine the number of
interaction effects between the moderator and some node in the network. If
a value between 0 and 1 is provided, then this determines the probability
of any given edge being moderated by the moderator.}

\item{m1}{Functions similarly to \code{m2}, except that this argument refers
to the number/probability of main effects of the moderator on any given
node.}

\item{m0}{Only relevant when \code{m = "ar"}. Determines the autoregressive
coefficient in the estimated models. Defaults to .3}

\item{lag}{Numeric value, supposed to indicate the number of lags to simulate
models parameters for. Recommended to leave at \code{1}.}

\item{thetaVar}{Numeric vector containing the variance associated with each
node (excluding the moderator) in the contemporaneous network. If
\code{NULL}, then it is assumed that the variance for each term is 1.}

\item{mu_SD}{Numeric vector of length 2. The first value determines the
standard deviation of the means associated with the temporal data, and the
second value determines the standard deviations of the means associated
with the between-subjects network.}

\item{init_beta_SD}{Similar to \code{mu_SD} except that it applies to the
coefficient estimates.}

\item{fixedMuSD}{Standard deviation of the random values for the means of the
fixed effects.}

\item{shrink_fixed}{Numeric value to determine the factor by which to shrink
sampled beta coefficients for fixed effects. Value between 0 and 1, where
higher values are recommended.}

\item{propPos}{The proportion of edges with a positive sign.}

\item{m1SD}{Standard deviation of the moderator main effect coefficients.}

\item{m2SD}{Standard deviation of the moderator interaction effect
coefficients.}

\item{m1_range}{Numeric vector of length 2. The range of values for moderator
main effect coefficients.}

\item{m2_range}{Numeric vector of length 2. The range of values for moderator
interaction effect coefficients.}

\item{shrink_deviation}{Numeric value to determine the factor by which to
shrink contemporaneous coefficients. Value between 0 and 1, where higher
values are recommended.}

\item{getM}{If \code{TRUE}, only the data for the moderator, the moderator
main effects, and interaction effects are returned.}

\item{contemporaneous}{Options include \code{"wishart", "randomGGM",
  "fixed"}. Determines how the contemporaneous network is sampled. The former
two options sample different matrices for each subject, whereas
\code{"fixed"} only samples one matrix and uses it for all subject
contemporaneous networks.}

\item{GGMsparsity}{Numeric value between 0 and 1. Determines the sparsity of
sampled network matrices.}

\item{mcenter}{If \code{TRUE} then the moderator variable is mean-centered.}

\item{skew}{If \code{TRUE} then random values will be generated to represent
the skewness of the node distributions. Alternatively, a numeric vector of
length \code{nNode} can be provided to specify the skewness of each
variable.}

\item{skewErr}{The skewness parameter for the \code{alpha} argument in the
\code{\link[sn:rmsn]{sn::rmsn}} function.}

\item{ordinal}{Logical. Determines whether to sample ordinal variables. If a
numeric value is provided, then this will automatically be assigned to the
\code{nLevels} argument.}

\item{nLevels}{Number of levels for the ordinal variables. Only relevant if
\code{ordinal} is not \code{FALSE}.}

\item{ordWithin}{If \code{TRUE}, then variables will ordinalized within
subjects, rather than across subjects.}

\item{minOrd}{The minimum number of unique values allowed for each variable.}

\item{thresholds}{List of length \code{k}, where each element is a numeric
vector of length \code{(nLevels - 1)} containing the splitpoints for
grouping each variable into ordered categories.}

\item{mseed}{Numeric value for the seed to be set when}

\item{onlyNets}{If \code{TRUE} then only the network models are returned,
without the data. Could be used to create random models and then simulate
data by another method.}

\item{modType}{Determines the type of moderation to employ, such as
\code{"none", "full", "partial"}. See \code{\link{simNet}}}
}
\value{
Simulated mlGVAR or VAR data.
}
\description{
Affords the generation of simulated data containing multiple timepoint
measurements for a number of subjects. Can simulate data with a single
moderator as well.
}
\details{
Made to simulate data based on pre-specified parameters, possibly for power
simulations or other analyses. Output can be used to fit models with either
\code{\link{mlGVAR}} or \code{\link{lmerVAR}}.
}
\examples{
set.seed(1)
x <- mlGVARsim(nTime = 50, nPerson = 10, nNode = 3, m = TRUE)
}
\seealso{
\code{\link{mlGVAR}, \link{lmerVAR}, \link{simNet}, \link{plotNet},
  \link{net}, \link{netInts}}
}
