% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_category_generation.R
\name{generate_xml_file}
\alias{generate_xml_file}
\alias{generate_xml_file.question_category}
\title{Generate questions xml file}
\usage{
generate_xml_file(qc, file)

\method{generate_xml_file}{question_category}(qc, file = NULL)
}
\arguments{
\item{qc}{A \code{question_category} object.}

\item{file}{A string, file name.}
}
\value{
A \code{question_category}.
}
\description{
Generate questions xml file
}
\examples{

qc <- question_category(category = 'Initial test') |>
  define_question(
    question = 'What are the basic arithmetic operations?',
    answer = 'Addition, subtraction, multiplication and division.',
    a_1 = 'Addition and subtraction.',
    a_2 = 'Addition, subtraction, multiplication, division and square root.'
  ) |>
  generate_xml_file(file = tempfile(fileext = '.xml'))

}
\seealso{
Other question definition functions: 
\code{\link{define_extended_question}()},
\code{\link{define_question}()},
\code{\link{define_questions_from_csv}()},
\code{\link{define_questions_from_data_frame}()},
\code{\link{define_questions_from_excel}()},
\code{\link{generate_xml}()},
\code{\link{question_category}()}
}
\concept{question definition functions}
