% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopwords.R
\name{remove.stopwords}
\alias{remove.stopwords}
\title{Removes stop words for a string the language of which is known}
\usage{
remove.stopwords(str, lang = "auto", fallback = "English")
}
\arguments{
\item{str}{A string or a vector of strings which to delete the stop words from}

\item{lang}{Either: \itemize{
 \item \code{'auto'} in which case \code{cld2} is used to perform language detection; or
 \item A string (or a vector of strings, depending on \code{str}) representing an ISO 639-2/3 or a language name from which to derive a ISO 639-2 code (for language names, string matching is performed)
}}

\item{fallback}{Fallback language in case \code{cld2} fails to detect the language of the manually-specified string does not match a supported language. Default to \code{'English'}.}
}
\value{
A strings (or a vector, depending on \code{str}) corresponding to the string/s \code{str} without stop words for the language/s \code{lang}.
}
\description{
Removes stop words for a string the language of which is known
}
\examples{
# Multiple strings in different languages
remove.stopwords(str = c(Gibberish = 'dadas',
                         Catalan = 'Adeu amic meu',
                         Irish = 'Slan a chara',
                         French = 'Je suis en Allemagne',
                         German = 'Eich liebe Deutschland'),
                 # Various ways of indicating the language
                 lang = c(NA, 'cata', 'Iris', 'fr', 'deu'),
                 # Yet another way
                 fallback = 'english'
                 )

}
