% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{launch_ui}
\alias{launch_ui}
\title{Launch the DuckDB UI in your browser}
\usage{
launch_ui(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
The function is called for its side effects and does not return a value.
It launches the DuckDB UI and opens it in your default web browser.
}
\description{
The \code{launch_ui()} function installs and launches the DuckDB UI extension
for an active DuckDB database connection. This allows users to interact
with the database via a web-based graphical interface.

The function will check that the connection is valid before proceeding.
}
\details{
The function performs the following steps:
\itemize{
\item Checks that the provided DuckDB connection is valid.
If the connection is invalid, it aborts with a descriptive error message.
\item Installs the \code{ui} extension into the connected DuckDB instance.
\item Calls the \code{start_ui()} procedure to launch the DuckDB UI in your browser.
}

This provides a convenient way to explore and manage DuckDB databases
interactively without needing to leave the R environment.
}
\examples{
\dontrun{
# Connect to DuckDB
con_db <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))

# Launch the DuckDB UI
launch_ui(con_db)

# Clean up
DBI::dbDisconnect(con_db, shutdown = TRUE)
}

}
\seealso{
Other db-meta: 
\code{\link{cd}()},
\code{\link{pwd}()}
}
\concept{db-meta}
