% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{validate_database_exists}
\alias{validate_database_exists}
\title{Check if a Database Exists}
\usage{
validate_database_exists(.con, database_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{A string specifying the database name to check.}
}
\value{
Logical \code{TRUE} if the database exists, \code{FALSE} otherwise.
}
\description{
Checks whether a database with the specified name exists on the current connection.
}
\details{
This function queries the available databases for the connection using
\code{motherduck::list_all_databases()} and performs an exact match check.
Returns \code{TRUE} if the database exists, \code{FALSE} otherwise.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb())
validate_database_exists(con, "test_db")
}

}
