% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_effect_GE.R
\name{QTL_effect_GE}
\alias{QTL_effect_GE}
\title{MPP GxE QTL genetic effects}
\usage{
QTL_effect_GE(
  mppData,
  trait,
  VCOV = "UN",
  ref_par = NULL,
  QTL = NULL,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function QTL_select() or
a vector of \code{character} marker positions names. Default = NULL.}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\item{Qeff}{\code{List} of \code{data.frame} (one per QTL) containing the
following information:

\enumerate{

\item{QTL genetic effects}
\item{Standard error of the QTL effects.}
\item{Wald statistics of the effects.}
\item{P-value of the test statistics.}
\item{Significance of the QTL effects.}

}

}
}
\description{
Estimate the QTL parental allelic effects within environment. The estimation
is performed using an exact mixed model with function from R package
\code{nlme}. The significance of the allele effect is assessed using a 
Wald test.
}
\details{
The estimated model is the following:

\eqn{\underline{y}_{icj} = E_{j} + C_{cj} + \sum_{q=1}^{n_{QTL}} x_{i_{q}p} * \beta_{pj} + \underline{GE}_{icj} + \underline{e}_{icj}}

For further details see the vignette.
}
\examples{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

Qeff <- QTL_effect_GE(mppData = mppData_GE, trait = c('DMY_CIAM', 'DMY_TUM'),
                      QTL = Qpos)

Qeff

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.
}
\author{
Vincent Garin
}
