% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_functions.R
\name{basis_functions}
\alias{basis_functions}
\alias{fourier_2d}
\alias{polynomial_2d}
\title{Creation of basis functions}
\usage{
fourier_2d(max_freqs, lattice_dim)

polynomial_2d(poly_deg, lattice_dim)
}
\arguments{
\item{max_freqs}{A length 2 numeric vector with maximum frequencies considered
(x-axis and y-axis direction, respectively).}

\item{lattice_dim}{A length 2 numeric vector with lattice dimensions (N,M)
to be used.}

\item{poly_deg}{A length 2 numeric vector with degrees of the bivariate
polynomial to be considered.}
}
\value{
A \code{list} of functions.
}
\description{
\code{fourier_2d()} and \code{polynomial_2d()} creates a \code{list} of basis
functions to be used as the fixed effect in \code{\link[=fit_ghm]{fit_ghm}}.
}
\details{
\code{fourier_2d()} is for 2-dimensional Fourier transform.
}
\examples{
\donttest{
fourier_2d(c(10,10), dim(Z_potts))
polynomial_2d(c(3,3), dim(Z_potts))
}
}
\seealso{
A paper with detailed description of the package can be found at
\doi{10.18637/jss.v101.i08}.
}
\author{
Victor Freguglia
}
