% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{ev_rep}
\alias{ev_rep}
\title{Replicate an event object}
\usage{
ev_rep(x, ID = 1, n = NULL, wait = 0, as.ev = FALSE, id = NULL)
}
\arguments{
\item{x}{event object.}

\item{ID}{numeric vector if IDs.}

\item{n}{passed to \code{\link[=ev_repeat]{ev_repeat()}}.}

\item{wait}{passed to \code{\link[=ev_repeat]{ev_repeat()}}.}

\item{as.ev}{if \code{TRUE} an event object is returned.}

\item{id}{deprecated; use \code{ID} instead.}
}
\value{
A single data.frame or event object as
determined by the value of \code{\link[=as.ev]{as.ev()}}.
}
\description{
An event sequence can be replicated a certain number of
times in a certain number of IDs.
}
\examples{

e1 <- c(ev(amt=100), ev(amt=200, ii=24, addl=2, time=72))

ev_rep(e1, 1:5)

}
\seealso{
\code{\link[=ev_repeat]{ev_repeat()}}
}
