#' @title Sample Data for Small Area Estimation using Hierarchical Bayesian Method under Multivariate T distribution
#'
#' @description Dataset to simulate Small Area Estimation using Hierarchical Bayesian Method under Multivariate T distribution
#'
#' This data is generated by these following steps:
#'
#' \enumerate{
#'   \item Generate sampling error \code{e}, random effect \code{u}, and auxiliary variables \code{X1 X2}.
#'   \itemize{
#'     \item For sampling error \code{e}, we set \eqn{e_{d}}{ed} is multivariate T distributed where the vector of noncentrality parameters is zero, scale matrix \eqn{V_{ed} = (\sigma_{dij})_{i,j=1,2,3}}{Ved = (\sigmadij)i,j=1,2,3}, with  \eqn{\sigma_{ii}}{\sigmaii}  ~ \eqn{InvGamma(a, b)}{InvGamma(a, b)} and \eqn{\rho_{e}}{\rhoe} = 0.5, and degree of freedom  \eqn{df}{df}  ~ \eqn{InvGamma(a, b)}{InvGamma(a, b)}.
#'     \item For random effect \code{u}, we set \eqn{u}{u} ~ \eqn{N_{3}(0, V_{u})}{N3(0, Vu)}.
#'     \item For auxiliary variables \code{X1 and X2}, we set \eqn{X1}{X1} ~ \eqn{UNIF(1,2)}{UNIF(1, 2)} and \eqn{X2}{X2} ~ \eqn{UNIF(1, 10)}{UNIF(1, 10)}.
#'   }
#'   \item Calculate direct estimation \code{Y1 Y2 and Y3} , where \eqn{Y_{i}}{Yi} = \eqn{X * \beta + u_{i} + e_{i}}{X\beta+ui+ei}. We take \eqn{\beta_{1} = 1}{\beta1 = 1} and \eqn{\beta_{2} = 1}{\beta2 = 1}.
#' }
#' Auxiliary variables \code{X1 X2}, direct estimation \code{Y1 Y2 Y3}, and sampling variance-covariance \code{v1 v2 v3 v12 v13 v23} are combined into a dataframe called datasaeT
#'
#'
#' @format A data frame with 30 rows and 11 variables:
#' \describe{
#'   \item{X1}{Auxiliary variable of X1}
#'   \item{X2}{Auxiliary variable of X2}
#'   \item{Y1}{Direct Estimation of Y1}
#'   \item{Y2}{Direct Estimation of Y2}
#'   \item{Y3}{Direct Estimation of Y3}
#'   \item{v1}{Sampling Variance of Y1}
#'   \item{v12}{Sampling Covariance of Y1 and Y2}
#'   \item{v13}{Sampling Covariance of Y1 and Y3}
#'   \item{v2}{Sampling Variance of Y2}
#'   \item{v23}{Sampling Covariance of Y2 and Y3}
#'   \item{v3}{Sampling Variance of Y3}
#' }

"datasaeT"
