% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bothsidesmodel.hotelling.R
\name{bothsidesmodel.hotelling}
\alias{bothsidesmodel.hotelling}
\title{Test blocks of \eqn{\beta} are zero.}
\usage{
bothsidesmodel.hotelling(x, y, z, rows, cols)
}
\arguments{
\item{x}{An \eqn{N \times P}{N x P} design matrix.}

\item{y}{The \eqn{N \times Q}{N x Q} matrix of observations.}

\item{z}{A \eqn{Q \times L}{Q x L} design matrix}

\item{rows}{The vector of rows to be tested.}

\item{cols}{The vector of columns to be tested.}
}
\value{
A list with the following components:

\describe{
 \item{Hotelling}{A list with the components of the Lawley-Hotelling \eqn{T^2} test (7.22)}
 \describe{
   \item{T2}{The \eqn{T^2} statistic (7.19).}
   \item{F}{The \eqn{F} version (7.22) of the \eqn{T^2} statistic.}
   \item{df}{The degrees of freedom for the \eqn{F}.}
   \item{pvalue}{The \eqn{p}-value of the \eqn{F}.}
 }
 \item{Wilks}{A list with the components of the Wilks \eqn{\Lambda} test (7.37)}
 \describe{
   \item{lambda}{The \eqn{\Lambda} statistic (7.35).}
   \item{Chisq}{The \eqn{\chi ^2} version (7.37) of the \eqn{\Lambda} statistic, using Bartlett's correction.}
   \item{df}{The degrees of freedom for the \eqn{\chi ^2}}.
   \item{pvalue}{The p-value of the \eqn{\chi ^2}}.
 }
}
}
\description{
Performs tests of the null hypothesis H0 : \eqn{\beta^*} = 0, where
\eqn{\beta^*} is a block submatrix of \eqn{\beta} as in Section 7.2.
}
\examples{
# Finds the Hotelling values for example 7.3.1
data(mouths)
x <- cbind(1, mouths[, 5])
y <- mouths[, 1:4]
z <- cbind(c(1, 1, 1, 1), c(-3, -1, 1, 3), c(1, -1, -1, 1), c(-1, 3, -3, 1))
bothsidesmodel.hotelling(x, y, z, 1:2, 3:4)
}
\seealso{
\code{\link{bothsidesmodel}}, \code{\link{bothsidesmodel.chisquare}},
         \code{\link{bothsidesmodel.df}}, \code{\link{bothsidesmodel.lrt}},
          and \code{\link{bothsidesmodel.mle}}.
}
