% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_correlation.R
\name{total_correlation}
\alias{total_correlation}
\alias{total_correlation}
\alias{C}
\title{Estimation of total correlation for a set of categorical random variables.}
\usage{
total_correlation(table_variables, table_class)

C(table_variables, table_class)
}
\arguments{
\item{table_variables}{A list of factors as categorical variables.}

\item{table_class}{A factor representing the class of the case.}
}
\value{
Total correlation estimation for the variable set
    {\code{table.variables}, \code{table.class}}.
}
\description{
Total Correlation is a generalization of information gain
(\code{\link[=information_gain]{IG}}) to measure the dependency of
a set of categorical random variables (see 
\url{https://en.wikipedia.org/wiki/Total_correlation}).
}
\examples{
total_correlation(list(factor(c(0,1)), factor(c(1,0))), factor(c(0,0)))
total_correlation(list(factor(c('a','b')), factor(c('a','b'))),
    factor(c('a','b')))
\dontrun{
total_correlation(list(factor(c(0,1)), factor(c(1,0))), c(0,0))
total_correlation(c(factor(c(0,1)), factor(c(1,0))), c(0,0))
}
}
