% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multBinExact_2-4.R
\name{plot.multfisher}
\alias{plot.multfisher}
\title{Plot Rejection Region from a \code{multfisher} Object}
\usage{
\method{plot}{multfisher}(x, dim = c(1, 2), slice = NULL,
  show.titles = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{multfisher}}

\item{dim}{a vector of length two, indicating which two dimensions of the rejection region to plot. The default is \code{c(1,2)}.
The argument is ignored if \code{x} was calculated for only one endpoint.}

\item{slice}{a named list of numeric values at which the test statistics for the dimensions (assumedly) not included in \code{dim} are held constant, see details.}

\item{show.titles}{logical indicating whether the plot title and explanatory subtitles are shown.}

\item{...}{further arguments passed to the generic \code{\link[graphics]{plot}} function.}
}
\description{
Plot two dimensions of the rejection region.
}
\details{
The function produces plots of the multivariate rejection regions calculated by \code{\link{mfisher.test}}. 
For more than two dimensions, the default \code{slice=NULL} shows a
projection of the rejection region on the two dimensions indicated in \code{dim}. \code{slice} may be specified to produce plots of slices through the 
multivariate rejection region. In that case \code{slice} must be a named list of numeric objects. The names must be of the form \code{Ti}, where \code{i} is replaced
by the number of the dimension to be indicated. The numeric value defines at which value the test statistic for the indicated dimension is held constant.
(If there are dimensions that are neither indicated in \code{dim} nor in \code{slice}, the plot is still a projection.)
}
\examples{
## Example with two endpoints
data<-data.frame(endpoint1=c(0,0,1,1,1,0,0,0,0,1,1,1,1,1,1, 0,0,1,0,0,1,1,1,1,1,1,1,1,1,1),
		endpoint2=  c(0,0,0,0,0,1,1,1,1,1,1,1,1,1,1, 0,0,0,1,1,1,1,1,1,1,1,1,1,1,1),
		group=rep(c(0,1),each=15))
plot(mfisher.test(x=data[,c(1:2)],y=data$group,show.region=TRUE),cex=2)

## Example with three endpoints
data3EP<-data.frame(endpoint1=  c(0,0,0,0,0,1,1,0,0,0, 0,0,0,0,1,1,1,1,1,1),
		  endpoint2=  c(0,0,0,0,0,1,0,1,0,0, 0,0,1,1,1,1,1,1,1,1),
		  endpoint3=  c(0,0,0,0,0,0,0,0,1,1, 0,0,0,1,1,1,1,1,1,1),
		  group=rep(c(0,1),each=10))
testgreedy3EP<-mfisher.test(x=data3EP[,1:3],y=data3EP$group,method="alpha.greedy",
	show.region=TRUE,closed.test=TRUE)
## Projecion on the first two dimensions
plot(testgreedy3EP,dim=c(1,2),cex=2)
## Slice at a value of 5 for the third dimension
plot(testgreedy3EP,dim=c(1,2),slice=list(T3=5),cex=2)
## Show all slices through the third dimension
par(mfrow=c(3,3))
for(i in 1:9) {
plot(testgreedy3EP,dim=c(1,2),slice=list(T3=i),show.titles=FALSE,cex=2,xlim=c(0,8),ylim=c(0,10))
title(paste("T3 =",i))
}

}
\seealso{
\code{\link{mfisher.test}}, \code{\link{print.multfisher}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
