% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiCA.R
\name{power.CA.test}
\alias{power.CA.test}
\title{Power calculations for the Cochran-Armitage trend test}
\usage{
power.CA.test(
  N = NULL,
  power = NULL,
  pvec = NULL,
  scores = seq_along(pvec),
  n.prop = rep(1, length(pvec)),
  sig.level = 0.05,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{N}{integer, the total sample size of the study. If \code{NULL} then \code{power} needs to be specified.}

\item{power}{target power. If \code{NULL} then \code{N} needs to be specified.}

\item{pvec}{numeric vector of hypothesized outcome probabilities in each group.}

\item{scores}{non-decreasing numeric vector of the same length as the number of ordered groups
giving the trend test scores. Defaults to linearly increasing values.}

\item{n.prop}{numeric vector describing relative sample sizes of the ordered groups.
Will be normalized to sum to 1. Defaults to equal sample sizes.}

\item{sig.level}{significance level}

\item{alternative}{character string specifying the alternative hypothesis}
}
\value{
object of class "power.htest"
}
\description{
Power calculations for the Cochran-Armitage trend test
}
\examples{
# sample size required to detect with 80\% power a decreasing trend over 4 groups 
# with 3:2:1:2 sample-size distribution at a 2.5\% significance level
power.CA.test(power=0.8, pvec=c(0.4, 0.3, 0.2, 0.1), n.prop=c(3,2,1,2),
              alternative = "less", sig.level=0.025)

# power of a 2-sided test to detect a logistic increase with slope 0.2 over 5 groups
# with groups of size 10 with unequal dose spacing
doses <- c(0,1,2,4,8)
p0 <- 0.05 # event probability at lowest dose
logit.props <- log(p0/(1-p0)) + doses * 0.2
p <- 1 / (1 + exp(-logit.props)) # hypothesized probabilities at each dose
power.CA.test(N = 10 * 5, pvec=p, scores = doses)

}
\references{
Nam, J. (1987). A Simple Approximation for Calculating Sample Sizes for Detecting Linear Trend in Proportions.
Biometrics, 43(3), 701-705.
}
