% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection_for_ML.R
\name{multiDEGGs_combined_filter}
\alias{multiDEGGs_combined_filter}
\title{Combined multiDEGGs filter}
\usage{
multiDEGGs_combined_filter(
  y,
  x,
  filter_method = "ttest",
  nfilter,
  dynamic_nfilter = TRUE,
  keep_single_genes = FALSE,
  ...
)
}
\arguments{
\item{y}{Numeric vector or factor. Response variable (outcome), i.e.
the 'metadata' named vector, as passed by \link[nestedcv]{nestcv.train} or
\link[nestedcv]{nestcv.glmnet}.}

\item{x}{Predictor variables, i.e. the assayData matrix with genes in columns
and IDs in rows, as passed by \link[nestedcv]{nestcv.train} or
\link[nestedcv]{nestcv.glmnet}.}

\item{filter_method}{Character string. Statistical filtering method to be
used in combination with multiDEGGs for sigle feature selection.
Options are: "ttest", "wilcoxon", "ranger", "glmnet", "pls".}

\item{nfilter}{Integer. Maximum number of features to select.}

\item{dynamic_nfilter}{Logical. If \code{TRUE} \code{nfilter} will limit the number of
features selected by the statistical filter and the feature space will be
augmented by adding ALL the paired predictors found by multiDEGGs.
If \code{FALSE} \code{nfilter} will limit the total number of predictors, with
approximately half allocated to pairs and half to single genes.}

\item{keep_single_genes}{Logical. When \code{dynamic_nfilter = TRUE}, determines
whether to include single genes selected by multiDEGGs (i.e. the single
variables included in the differential pairs) in addition to those from
the statistical filter. Default is FALSE.}

\item{...}{Additional arguments passed to the filtering functions.}
}
\value{
An object of class "multiDEGGs_filter" containing:
\item{keep}{Character vector of selected single gene names}
\item{pairs}{Data frame of selected gene pairs with interaction information}
}
\description{
This function can be passed to the \code{modifyX} parameter of
\link[nestedcv]{nestcv.train} or \link[nestedcv]{nestcv.glmnet}
to use one of the available statistical filters (t-test, wilcoxon, etc.) in
combination with multiDEGGs.
Single predictors will be selected by the selected statistical filter an
paired predictors will be added by multiDEGGs.
}
\details{
The function operates in two modes:

\strong{Dynamic Filtering (dynamic_nfilter = TRUE):}
\itemize{
\item Selects \code{nfilter} single genes using the specified statistical method
\item Finds all significant gene pairs using multiDEGGs
\item Total predictors = nfilter single genes + number of significant pairs
\itemize{
\item If \code{keep_single_genes = TRUE}, also includes single genes obtained
from pairs found by multiDEGGs
}
}

\strong{Balanced Selection (dynamic_nfilter = FALSE):}
\itemize{
\item Allocates approximately half of \code{nfilter} to gene pairs
\item Remaining slots filled with single genes from the statistical filter
\item If fewer pairs are found than allocated, compensates by selecting more
single genes
\item Ensures consistent total number of predictors across outer folds
}

The statistical filtering methods include:
\itemize{
\item \code{"ttest"}: Two-sample t-test for differential expression
\item \code{"wilcoxon"}: Wilcoxon rank-sum test
\item \code{"ranger"}: Random Forest variable importance
\item \code{"glmnet"}: Elastic net regularization
\item \code{"pls"}: Partial Least Squares variable importance
}
}
\examples{
library(nestedcv)
data("synthetic_metadata")
data("synthetic_rnaseqData")

# fit a regularized linear model
# note that nfilter, n_outer_folds, n_inner_folds are set low to keep the
# example lightweight. Adjust these values as needed for your use case.
\dontrun{
fit.glmnet <- nestedcv::nestcv.glmnet(
y = as.numeric(synthetic_metadata$response),
x =  t(synthetic_rnaseqData),
modifyX = "multiDEGGs_combined_filter",
modifyX_options = list(filter_method = "ttest", 
                       nfilter = 5,
                       dynamic_nfilter = TRUE, 
                       keep_single_genes = FALSE),
modifyX_useY = TRUE,
n_outer_folds = 4,
n_inner_folds = 4)

summary(fit.glmnet)
}

# fit a random forest model
# NOTE: nfilter, n_outer_folds, n_inner_folds are set low to keep the
# example lightweight. Adjust these values as needed for your use case.
fit.rf <- nestedcv::nestcv.train(
  y = synthetic_metadata$response,
  x = t(synthetic_rnaseqData),
  method = "rf",
  modifyX = "multiDEGGs_combined_filter",
  modifyX_options = list(filter_method = "ttest", 
                         nfilter = 5,
                         dynamic_nfilter = TRUE, 
                         keep_single_genes = FALSE),
  modifyX_useY = TRUE,
  n_outer_folds = 2,
  n_inner_folds = 2
)

fit.rf$summary

}
