% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_2_SBI.R
\name{estimate_2_SBI}
\alias{estimate_2_SBI}
\title{Simulated-Based Inference (SBI)}
\usage{
estimate_2_SBI(model, env, priors, control = list(), ...)
}
\arguments{
\item{model}{Reinforcement Learning Model}

\item{env}{multiRL.env}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A \code{List} containing, for each model, simulated data generated
  using randomly sampled parameters.
}
\description{
Since both Approximate Bayesian Computation (ABC) and Recurrent Neural 
   Network (RNN) are simulation-based inference methods, they require a 
   model built from a large amount of simulated data before running. This 
   model is then used to predict the most likely input parameters 
   corresponding to the real data. Therefore, this function generates random 
   input parameters using user-specified distributions and produces 
   simulated data based on these parameters.
}
