% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotProfiles}
\alias{plotProfiles}
\title{Plot profile likelihoods}
\usage{
plotProfiles(fit, n = 100, showInitial = FALSE, maxiter = 50, tolerance = 0.1)
}
\arguments{
\item{fit}{list, the fit object from multiRec. The fit object must be
generated by calling multiRec with fitDetails=TRUE (the default is FALSE)}

\item{n}{integer, the number of points on the profile likelihood plot}

\item{showInitial}{logical, if TRUE the initial parameter estimates are shown
on the figures as a hollow dot.}

\item{maxiter}{integer, the number of iterations used to identify the
x axis range on each figure.}

\item{tolerance}{numeric, a multiplicative factor used the set the y axis
range on each figure: the axis will range from approximately the maximum
of the log likelihood to (1+tolerance) times the maximum}
}
\value{
No return value; called for side effects (creates profile likelihood plots).
}
\description{
Plot profile likelihoods
}
\details{
The function generates a series of plots, one for each parameter in the
model. Each plot shows the log likelihood on the vertical axis and a range of
values for the parameter on the horizontal axis. The plot for a specific
parameter is obtained by fixing the remaining parameters at their maximum
likelihood value, and varying the plotted parameter over a range of values.
The range of values is selected in such a way that the resulting likelihood
ranges from 90% of the maximum to 100% of the maximum.

Plotting profile likelihoods is particularly important when using the
identity link as it tends to have ill behaved likelihoods. When looking at
profile plots, looks for multiple maxima, especially ones for which the
corresponding likelihoods are similar in magnitude: if they exist, the
interpretation of the fit returned by the model is questionable as there
are other solutions that fit the data (almost) as well.  Also look for
discontinuities and sharp changes in slope (i.e discontinuities in the first
derivatives) as these will often cause convergence problems.
}
\examples{
fit = multiRec(hf   ~ nPrior.afib(~male),
               afib ~ age + nPrior.afib() + nPrior.hf(),
               data=multiRecCVD2,
               idVar='id',
               link='log',
               fitDetails=TRUE)
plotProfiles(fit)

}
