% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_population.R
\name{calc_phi_simple}
\alias{calc_phi_simple}
\alias{calc_NPR}
\title{Simple spawners per recruit calculation}
\usage{
calc_phi_simple(Z, fec_a, mat_a, delta = 0)

calc_NPR(Z, na = length(Z), plusgroup = TRUE)
}
\arguments{
\item{Z}{Total mortality at age}

\item{fec_a}{Fecundity at age. Vector}

\item{mat_a}{Maturity at age. Vector}

\item{delta}{Fraction of season that elapses when spawning occurs, e.g., midseason spawning when \code{delta = 0.5}.}

\item{na}{Integer, number of age classes}

\item{plusgroup}{Logical, whether the largest age class is a plusgroup accumulator age}
}
\value{
\code{\link[=calc_phi_simple]{calc_phi_simple()}} returns a numeric for the spawning biomass per recruit.

\code{\link[=calc_NPR]{calc_NPR()}} returns a numeric, numbers per recruit at age
}
\description{
Calculate spawners per recruit by individual stock. Appropriate for a population model with a single
spatial area and an annual time steps, i.e. single season.
}
\seealso{
\code{\link[=calc_phi_project]{calc_phi_project()}}
}
