% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edge_multip_seq.R
\name{get_edge_multip_seq}
\alias{get_edge_multip_seq}
\title{Edge multiplicity sequences of multigraphs given fixed degrees}
\usage{
get_edge_multip_seq(deg.seq)
}
\arguments{
\item{deg.seq}{vector of integers with the sum equal to 2\code{m} representing
the degree sequence of the multigraph.}
}
\value{
All unique edge multiplicity sequences as rows in a data frame.
Each row in the data frame represents a unique multigraph given the degree sequence.
}
\description{
Given a degree sequence, this function finds all unique multigraphs
represented by their edge multiplicity sequences.
}
\details{
Multigraphs are represented by their edge multiplicity sequence \strong{M} with elements \emph{M(i,j)},
denoting edge multiplicity at possible vertex pair sites \emph{(i,j)} ordered according to\cr
\emph{(1,1) < (1,2) <···< (1,n) < (2,2) < (2,3) <···< (n,n)}, \cr
where \emph{n} is number of nodes.

Only practical for small multigraphs.
}
\examples{
# Adjacency matrix for undirected network with 3 nodes
A <- matrix(c(
    0, 1, 2,
    1, 2, 1,
    2, 1, 2
), nrow = 3, ncol = 3)
deg <- get_degree_seq(A, "multigraph")
get_edge_multip_seq(deg)
}
\references{
Shafie, T. (2015). A Multigraph Approach to Social Network Analysis. \emph{Journal of Social Structure}, 16.
\cr

Shafie, T. (2016). Analyzing Local and Global Properties of Multigraphs. \emph{The Journal of Mathematical Sociology}, 40(4), 239-264.
\cr
#' Shafie, T., Schoch, D. (2021). Multiplexity analysis of networks using multigraph representations.
\emph{Statistical Methods & Applications} 30, 1425–1444.
}
\seealso{
\code{\link{get_degree_seq}}
}
\author{
Termeh Shafie
}
