% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{indirect_pathwise}
\alias{indirect_pathwise}
\title{Indirect Effects via Single Mediation Paths}
\usage{
indirect_pathwise(model, exper = NULL, t1 = 1, t2 = 2, progress = TRUE)
}
\arguments{
\item{model}{An object of class multimedia containing the estimated mediation
and outcome models whose mediation and outcome predictions we want to
compare.}

\item{exper}{An object of class multimedia_data containing the mediation and
outcome data from which the direct effects are to be estimated.}

\item{t1}{The reference level of the treatment to be used when computing the
(pathwise) indirect effect.}

\item{t2}{The alternative level of the treatment to be used when computing
the (pathwise) indirect effect.}

\item{progress}{A logical indicating whether to show a progress bar.}
}
\value{
A data.frame summarizing the pathwise (per-mediator) indirect effects
associated with different settings of the direct effect.
}
\description{
Indirect Effects via Single Mediation Paths
}
\examples{
# example with null data
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
fit <- multimedia(exper) |>
    estimate(exper)
indirect_pathwise(fit)

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
fit <- multimedia(exper) |>
    estimate(exper)
indirect_pathwise(fit)
}
