% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Z_random.r
\name{make_Z_random}
\alias{make_Z_random}
\title{Start from random groups of similar size.}
\usage{
make_Z_random(D, seed = NULL)
}
\arguments{
\item{D}{an object of class \code{multimixSettings} -- see 
\code{\link{data_organise}} for more information.}

\item{seed}{a positive integer to use as a random number seed.}
}
\value{
a matrix of dimension \eqn{n\times q}{n by q} where 
\eqn{n}{n} is the number of observations in \code{D$dframe}
and \eqn{q}{q} is the number of clusters in the model as specified
by \code{D$numClusters}.
}
\description{
A large number (\eqn{n}{n}) of observations are assigned randomly into
(\eqn{xq}{xq}) clusters. It is recommended to repeat Multimix runs with a
number of different seeds to search for a log-likelihood maximum.
}
\details{
Also consider making additional clusters from observations with low
probabilities of belonging to any cluster in a previous clustering.
}
\examples{
data(cancer.df)
D = data_organise(cancer.df, numClusters = 2)
Z = make_Z_random(D)
table(Z)
}
