% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmain.r
\name{mmain}
\alias{mmain}
\title{Title}
\usage{
mmain(D, Z, P, eps = 1e-09)
}
\arguments{
\item{D}{an object of class \code{multimixSettings} - see
\code{\link{data_organise}} for full description.}

\item{Z}{a matrix}

\item{P}{a matrix}

\item{eps}{Minimum increase in loglikelihood per EM step. If this is not
exceeded the the algorithm will terminate.}
}
\value{
an object of class \code{multimix results} which is a a list
  containing four elements: the \code{multmixSettings} object \code{D},
  the \eqn{Z}{Z} matrix, the \eqn{P}{P} matrix,
  and a results matrix, called \code{results}, with \eqn{n}{n} rows and
  \eqn{numClusters}{numClusters} columns.
}
\description{
Title
}
\examples{
data(cancer.df)
D <- data_organise(cancer.df, numClusters = 2)
stage <- scan(system.file('extdata', 'Stage.txt', package = 'multimix')) - 2
Z <- make_Z_discrete(stage)
P <- initParamList(D,Z) 
zpr <- mmain(D,Z,P)
zpr
}
\author{
Murray Jorgensen
}
