% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_size_additive.R
\name{effect_size_additive}
\alias{effect_size_additive}
\title{Additive Null Model}
\usage{
effect_size_additive(
  Control_N,
  Control_SD,
  Control_Mean,
  StressorA_N,
  StressorA_SD,
  StressorA_Mean,
  StressorB_N,
  StressorB_SD,
  StressorB_Mean,
  StressorsAB_N,
  StressorsAB_SD,
  StressorsAB_Mean,
  Small_Sample_Correction,
  Significance_Level
)
}
\arguments{
\item{Control_N}{Sample size of the control treatment (numeric)}

\item{Control_SD}{Standard deviation of the control treatment (numeric)}

\item{Control_Mean}{Mean value of the control treatment (numeric)}

\item{StressorA_N}{Sample size of stressor A treatment (numeric)}

\item{StressorA_SD}{Standard deviation of stressor A treatment (numeric)}

\item{StressorA_Mean}{Mean value of stressor A treatment (numeric)}

\item{StressorB_N}{Sample size of stressor B treatment (numeric)}

\item{StressorB_SD}{Standard deviation of stressor B treatment (numeric)}

\item{StressorB_Mean}{Mean value of stressor B treatment (numeric)}

\item{StressorsAB_N}{Sample size of stressors A and B treatment (numeric)}

\item{StressorsAB_SD}{Standard deviation of stressors A and B treatment (numeric)}

\item{StressorsAB_Mean}{Mean value of stressors A and B treatment (numeric)}

\item{Small_Sample_Correction}{Whether the correction for small sample sizes should be enacted
(TRUE or FALSE; default is TRUE)}

\item{Significance_Level}{The value of alpha for which confidence intervals are calculated
(numeric, between 0 and 1; default is 0.05)}
}
\value{
The function returns a dataframe containing

 i.   effect sizes

 ii.  effect size variances

 iii. upper and lower confidence intervals

 iv.  user specified numeric parameters

The equations used to calculate effect sizes, effect size variances, and confidence intervals
are described in \emph{Burgess et al. (2021)}.

Note that the parameter \emph{Small_Sample_Correction} determines whether the correction for sample
sizes is to be used within the function. This correction (see \emph{Borenstein et al. (2009)}) tends towards 1
as sample sizes increase. Hence it is most applicable where small sample sizes are used.
}
\description{
Calculate the additive null model for one, or more, experiments.
}
\details{
The form of the additive null model used here is taken from \emph{Gurevitch et al. (2000)}.

Interaction effect sizes, variances, and confidence intervals are calculated.

Here, the factorial form of Hedges' d is calculated.
}
\examples{
df <- effect_size_additive(Control_N = 4,
                    Control_SD = 0.114,
                    Control_Mean = 0.90,
                    StressorA_N = 4,
                    StressorA_SD = 0.11,
                    StressorA_Mean = 0.77,
                    StressorB_N = 3,
                    StressorB_SD = 0.143,
                    StressorB_Mean = 0.72,
                    StressorsAB_N = 4,
                    StressorsAB_SD = 0.088,
                    StressorsAB_Mean = 0.55,
                    Small_Sample_Correction = TRUE,
                    Significance_Level = 0.05)

#loading up an example dataset from the multiplestressR package
df <- multiplestressR::survival

#calculating effect sizes
df <- effect_size_additive(Control_N         = df$Sample_Size_Control,
                           Control_SD        = df$Standard_Deviation_Control,
                           Control_Mean      = df$Mean_Control,
                           StressorA_N       = df$Sample_Size_Temperature,
                           StressorA_SD      = df$Standard_Deviation_Temperature,
                           StressorA_Mean    = df$Mean_Temperature,
                           StressorB_N       = df$Sample_Size_pH,
                           StressorB_SD      = df$Standard_Deviation_pH,
                           StressorB_Mean    = df$Mean_pH,
                           StressorsAB_N     = df$Sample_Size_Temperature_pH,
                           StressorsAB_SD    = df$Standard_Deviation_Temperature_pH,
                           StressorsAB_Mean  = df$Mean_Temperature_pH,
                           Significance_Level = 0.05);


}
\references{
Borenstein, M., Cooper, H., Hedges, L., & Valentine, J. (2009). Effect sizes for continuous data. \emph{The Handbook of Research Synthesis and Meta-Analysis}, 2, 221-235.

Burgess, B. J., Jackson, M. C., & Murrell, D. J. (2021). Multiple stressor null models frequently fail to detect most interactions due to low statistical power. \emph{bioRxiv}.

Gurevitch, J., Morrison, J. A., & Hedges, L. V. (2000). The interaction between competition and predation: a meta-analysis of field experiments. \emph{The American Naturalist}, 155(4), 435-453.
}
