% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{attachContext}
\alias{attachContext}
\title{Attach Nucleotide Context.}
\usage{
attachContext(
  mutData,
  BSGenomeDb,
  chr_colName = "chr",
  start_colName = "start_position",
  end_colName = "end_position",
  nucl_contextN = 3,
  context_colName = "context"
)
}
\arguments{
\item{mutData}{data.frame storing mutation data}

\item{BSGenomeDb}{a BSGenomeDb-class object, storing info about the genome of interest}

\item{chr_colName}{string, name of the column storing seqNames. Defaults to "chr"}

\item{start_colName}{string, name of the column storing start positions. Defaults to "start_position"}

\item{end_colName}{string, name of the column storing end positions. Defaults to "end_position"}

\item{nucl_contextN}{integer, the span of nucleotides to be retrieved around the variant. Defaults to 3}

\item{context_colName}{string, name of the column that will be storing the 
nucleotide context. Defaults to "context"}
}
\value{
a modified data.frame including the nucleotide context in a new column
}
\description{
Retrieve the nucleotide context around each DNA variant based on the
genomic coordinates of the variant and a reference BSGenome database.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
