% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_types.R
\name{mutation_types_identify}
\alias{mutation_types_identify}
\title{Identify Mutation Dictionary Used}
\usage{
mutation_types_identify(
  mutation_types,
  split_on_ampersand = TRUE,
  verbose = TRUE,
  ignore_missing = FALSE
)
}
\arguments{
\item{mutation_types}{mutation types to test (character)}

\item{split_on_ampersand}{split mutation types in a single string separated by ampersand (&) into 2 distinct mutation type columns (flag)}

\item{verbose}{verbose (flag)}

\item{ignore_missing}{should we ignore missing (NA) or empty ('') mutation_types when identifying a classification scheme (flag)}
}
\value{
one of c('SO', 'MAF', 'UNKNOWN').
Will return 'UNKNOWN' unless ALL mutation types fit with one of the supported dictionaries
}
\description{
Looks at variant consequence terms and guesses what mutation dictionary was used.
SO and PAVE dictionaries overlap, meaning an observed set of terms can perfectly match both ontologies.
If this happens, we assume they are SO terms.
}
\examples{
mutation_types_identify(c('bob', 'billy', 'missense_variant'))
}
