% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_curve.R
\name{spec_summary}
\alias{spec_summary}
\title{Create a specification table for a selected variable.}
\usage{
spec_summary(.mverse, var, conf.int = TRUE, conf.level = 0.95)
}
\arguments{
\item{.mverse}{A \code{mverse} object.}

\item{var}{A character specifying the variable of interest.}

\item{conf.int}{Whether the table should include confidence intervals.}

\item{conf.level}{The confidence level for the confidence level and
\code{is_significant}.}
}
\value{
A \code{spec_summary} object that includes estimates and
  specification across the multiverse for the selected term(s). A boolean
  column \code{is_significant} indicates whether \code{p.value} for the
  universe is less than the specified significance level
  (\code{1 - conf.level}).
}
\description{
Returns estimates for a selected variable across the multiverse along with
the universe specification information in a table. The resulting table
can be used for \code{spe_curve()}.
}
\examples{
femininity <- mutate_branch(
  1 * (MasFem > 6), 1 * (MasFem > mean(MasFem))
)
intensity <- mutate_branch(
  Minpressure_Updated_2014,
  Category,
  NDAM,
  HighestWindSpeed
)
model <- formula_branch(
  log(alldeaths + 1) ~ femininity,
  log(alldeaths + 1) ~ femininity * intensity
)
mv <- mverse(hurricane) \%>\%
  add_mutate_branch(femininity) \%>\%
  add_mutate_branch(intensity) \%>\%
  add_formula_branch(model) \%>\%
  lm_mverse()
spec_summary(mv, "femininity")
}
\seealso{
Other specification curve analysis: 
\code{\link{spec_curve}()}
}
\concept{specification curve analysis}
