% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getstartvals.R
\name{getstartvals}
\alias{getstartvals}
\title{Obtain starting values for maximum likelihood estimation.}
\usage{
getstartvals(x, eps = 0.001)
}
\arguments{
\item{x}{Multivariate data, potentially with missing values.}

\item{eps}{All eigenvalues of the variance-covariance matrix less than
\code{eps} times the smallest positive eigenvalue are set to
\code{eps} times the smallest positive eigenvalue.}
}
\value{
A numeric vector, containing the mean vector first, followed
by the log of the diagonal elements of the inverse of the Cholesky
factor of the adjusted sample variance-covariance matrix, and then
the elements of the inverse of the Cholesky factor above the main diagonal.  These off-diagonal elements are
ordered by column (left to right), and then by row within column
(top to bottom).
}
\description{
Calculates the starting values to be passed to \code{nlm} for
minimization of the negative log-likelihood for multivariate normal
data with missing values.  This function is private to \code{mlest}.
}
\details{
Starting values for the mean vector are simply sample means.  Starting
values for the variance-covariance matrix are derived from the sample
variance-covariance matrix, after setting eigenvalues less than
\code{eps} times the smallest positive eigenvalue equal to \code{eps}
times the smallest positive eigenvalue to enforce positive definiteness.
}
\seealso{
\code{\link{mlest}}
}
\keyword{multivariate}
