% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvvg.R
\name{rmvvg}
\alias{rmvvg}
\title{Generate Matrix-Variate Variance Gamma Samples}
\usage{
rmvvg(n, M, A, Sigma, Psi, gamma)
}
\arguments{
\item{n}{number of observations}

\item{M}{\eqn{p \times q} location matrix}

\item{A}{\eqn{p \times q} skewness matrix}

\item{Sigma}{\eqn{p \times p} covariance matrix}

\item{Psi}{\eqn{q \times q} covariance matrix}

\item{gamma}{scalar mixing parameter}
}
\value{
rmvvg returns a list of random samples.
}
\description{
Generates random samples from the matrix-variate variance gamma (MVVG) distribution, under the identifiability constraint set by [].
}
\details{
MVVG samples are formulated through the normal variance-mean mixture \eqn{M + WA + \sqrt{W}Z}, where \eqn{W \sim Gamma(\gamma, \gamma)}.

Gamma must be \eqn{>0}. Sigma and  Psi must be positive definite covariance matrices.
}
\examples{
M <- cbind(rep(1, 5), c(1, 0, 1, 0, 1))
A <- matrix(c(1,2), 5, 2, byrow = TRUE)
Sigma <- diag(5)
Psi <- matrix(c(4,2,2,3), 2, 2)
gamma <- 3

rmvvg(2, M, A, Sigma, Psi, gamma)
}
\seealso{
\code{\link{dmvvg}}
}
\author{
Samuel Soon
}
