% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mx_umap.R
\name{plot_mx_umap}
\alias{plot_mx_umap}
\title{Visualize UMAP dimension reduction algorithm}
\usage{
plot_mx_umap(mx_data, metadata_col = NULL)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object that been used with \code{run_reduce_umap()} to compute the UMAP dimensions for the dataset. Note that the table attribute must be set when running \code{run_reduce_umap()}.}

\item{metadata_col}{column denoted in the \code{run_reduce_umap()} to change the scale_color attribute of the ggplot (default=NULL)}
}
\value{
\code{ggplot2} object with density plot
}
\description{
Visualize UMAP dimension reduction algorithm
}
\examples{
mx_data = mx_dataset(mxnorm::mx_sample, "slide_id", "image_id",
  c("marker1_vals","marker2_vals","marker3_vals"),
  c("metadata1_vals"))
mx_data = mx_normalize(mx_data, transform="log10",method="None")
mx_data = run_reduce_umap(mx_data, table="normalized",
c("marker1_vals","marker2_vals","marker3_vals"))
plot_mx_umap(mx_data)
}
