% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_mean.R
\name{impute_mean}
\alias{impute_mean}
\alias{impute_mean.default}
\alias{impute_mean.factor}
\title{Impute the mean value into a vector with missing values}
\usage{
impute_mean(x)

\method{impute_mean}{default}(x)

\method{impute_mean}{factor}(x)
}
\arguments{
\item{x}{vector}
}
\value{
vector with mean values replaced
}
\description{
This can be useful if you are imputing specific values, however we would
generally recommend to impute using other model based approaches. See
the \code{simputation} package, for example \code{\link[simputation:impute_lm]{simputation::impute_lm()}}.
}
\examples{

library(dplyr)
vec <- rnorm(10)

vec[sample(1:10, 3)] <- NA

impute_mean(vec)

dat <- tibble(
  num = rnorm(10),
  int = as.integer(rpois(10, 5)),
  fct = factor(LETTERS[1:10])
) \%>\%
  mutate(
    across(
      everything(),
      \(x) set_prop_miss(x, prop = 0.25)
    )
  )

dat

dat \%>\%
  nabular() \%>\%
  mutate(
    num = impute_mean(num),
    int = impute_mean(int),
    fct = impute_mean(fct),
  )

dat \%>\%
  nabular() \%>\%
  mutate(
    across(
      where(is.numeric),
      impute_mean
    )
  )

dat \%>\%
  nabular() \%>\%
  mutate(
    across(
      c("num", "int"),
      impute_mean
    )
  )

}
