% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{call_aio}
\alias{call_aio}
\alias{call_aio_}
\title{Call the Value of an Asynchronous Aio Operation}
\usage{
call_aio(x)

call_aio_(x)
}
\arguments{
\item{x}{an Aio or list of Aios (objects of class 'sendAio', 'recvAio' or
'ncurlAio').}
}
\value{
The passed object (invisibly).
}
\description{
\code{call_aio} retrieves the value of an asynchronous Aio operation, waiting
for the operation to complete if still in progress. For a list of Aios, waits
for all asynchronous operations to complete before returning.

\code{call_aio_} is a variant that allows user interrupts, suitable for
interactive use.
}
\details{
For a 'recvAio', the received value may be retrieved at \verb{$data}.

For a 'sendAio', the send result may be retrieved at \verb{$result}.
This will be zero on success, or else an integer error code.

To access the values directly, use for example on a 'recvAio' \code{x}:
\code{call_aio(x)$data}.

For a 'recvAio', if an error occurred in unserialization or conversion of the
message data to the specified mode, a raw vector will be returned instead to
allow recovery (accompanied by a warning).

Note: this function operates silently and does not error even if \code{x} is not
an active Aio or list of Aios, always returning invisibly the passed object.
}
\section{Alternatively}{


Aio values may be accessed directly at \verb{$result} for a 'sendAio', and \verb{$data}
for a 'recvAio'. If the Aio operation is yet to complete, an 'unresolved'
logical NA will be returned. Once complete, the resolved value will be
returned instead.

\code{\link[=unresolved]{unresolved()}} may also be used, which returns \code{TRUE} only if an Aio or Aio
value has yet to resolve and \code{FALSE} otherwise. This is suitable for use in
control flow statements such as \code{while} or \code{if}.
}

\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

res <- send_aio(s1, data.frame(a = 1, b = 2), timeout = 100)
res
call_aio(res)
res$result

msg <- recv_aio(s2, timeout = 100)
msg
call_aio_(msg)$data

close(s1)
close(s2)

}
