% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.r
\name{RunCmdForNewerInput}
\alias{RunCmdForNewerInput}
\title{Run a command if input files are newer than outputs}
\usage{
RunCmdForNewerInput(
  cmd,
  infiles,
  outfiles,
  Verbose = FALSE,
  UseLock = FALSE,
  Force = FALSE,
  ReturnInputTimes = FALSE,
  ...
)
}
\arguments{
\item{cmd}{An \code{\link{expression}}, a string or NA/NULL}

\item{infiles}{Character vector of path to one or more input files}

\item{outfiles}{Character vector of path to one or more output files}

\item{Verbose}{Write information to consolse (Default FALSE)}

\item{UseLock}{Stop other processes working on this task (Default FALSE)}

\item{Force}{Ignore file modification times and always produce output
if input files exist.}

\item{ReturnInputTimes}{Return mtimes of input files (default FALSE)}

\item{...}{additional parameters passed to \code{\link{system}} call.}
}
\value{
logical indicating if cmd was run or for an R expression, eval(cmd)
}
\description{
Run a command if input files are newer than outputs
}
\details{
\code{cmd} can be an R \code{expression}, which is 
  \code{\link{eval}}uated if necessary in the environment calling 
  \code{RunCmdForNewerInput}, a string to be passed to \code{\link{system}} 
  or NULL/NA in which cases the files are checked and \code{TRUE} or 
  \code{FALSE} is returned depending on whether action is required.
  
  When \code{UseLock=TRUE}, the lock file created is called outfiles[1].lock
  
  When \code{ReturnInputTimes=TRUE}, the input mtimes are returned as an 
  attribute of a logical value (if available).
}
\examples{
\dontrun{
RunCmdForNewerInput(expression(myfunc("somefile")))
}
}
\seealso{
\code{\link{makelock}, \link{eval}, \link{expression}}
}
