% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{c_ListofMatrixRows}
\alias{c_ListofMatrixRows}
\title{Convert a matrix into list of row vectors}
\usage{
c_ListofMatrixRows(object)
}
\arguments{
\item{object}{An integer, numeric, character or logical matrix of N rows and
M columns}
}
\value{
a list containing N vectors of length M corresponding to the rows of
  \code{object}.
}
\description{
Convert a matrix into list of row vectors
}
\details{
Typically this will be for 3D coordinates but there are no limits
  on row length.
}
\examples{
\dontrun{
library(nat)
xyz=xyzmatrix(Cell07PNs)
mat2list = function(m) {
um=unname(m)
lapply(1:nrow(um), function(i) um[i,])
}
bench::mark(rcpp=c_ListofMatrixRows(xyz), r=mat2list(xyz))
}
}
