% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{gic.ncpen}
\alias{gic.ncpen}
\title{gic.ncpen: compute the generalized information criterion (GIC) for the selection of lambda}
\usage{
gic.ncpen(fit, weight = NULL, verbose = TRUE, ...)
}
\arguments{
\item{fit}{(ncpen object) fitted \code{ncpen} object.}

\item{weight}{(numeric) the weight factor for various information criteria.
Default is BIC if \code{n>p} and GIC if \code{n<p} (see details).}

\item{verbose}{(logical) whether to plot the GIC curve.}

\item{...}{other graphical parameters to \code{\link{plot}}.}
}
\value{
The coefficients \code{\link{matrix}}.
  \item{gic}{the GIC values.}
  \item{lambda}{the sequence of lambda values used to calculate GIC.}
  \item{opt.beta}{the optimal coefficients selected by GIC.}
  \item{opt.lambda}{the optimal lambda value.}
}
\description{
The function provides the selection of the regularization parameter lambda based
on the GIC including AIC and BIC.
}
\details{
User can supply various \code{weight} values (see references). For example,
\code{weight=2},
\code{weight=log(n)},
\code{weight=log(log(p))log(n)},
\code{weight=log(log(n))log(p)},
corresponds to AIC, BIC (fixed dimensional model), modified BIC (diverging dimensional model) and GIC (high dimensional model).
}
\examples{
### linear regression with scad penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,cf.min=0.5,cf.max=1,corr=0.5)
x.mat = sam$x.mat; y.vec = sam$y.vec
fit = ncpen(y.vec=y.vec,x.mat=x.mat)
gic.ncpen(fit,pch="*",type="b")
### multinomial regression with classo penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,k=3,cf.min=0.5,cf.max=1,corr=0.5,family="multinomial")
x.mat = sam$x.mat; y.vec = sam$y.vec
fit = ncpen(y.vec=y.vec,x.mat=x.mat,family="multinomial",penalty="classo")
gic.ncpen(fit,pch="*",type="b")
}
\references{
Wang, H., Li, R. and Tsai, C.L. (2007). Tuning parameter selectors for the smoothly clipped absolute deviation method.
\emph{Biometrika}, 94(3), 553-568.
Wang, H., Li, B. and Leng, C. (2009). Shrinkage tuning parameter selection with a diverging number of parameters.
\emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, 71(3), 671-683.
Kim, Y., Kwon, S. and Choi, H. (2012). Consistent Model Selection Criteria on High Dimensions.
\emph{Journal of Machine Learning Research}, 13, 1037-1057.
Fan, Y. and Tang, C.Y. (2013). Tuning parameter selection in high dimensional penalized likelihood.
\emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, 75(3), 531-552.
Lee, S., Kwon, S. and Kim, Y. (2016). A modified local quadratic approximation algorithm for penalized optimization problems.
\emph{Computational Statistics and Data Analysis}, 94, 275-286.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
