% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{npe_summary}
\alias{npe_summary}
\title{Get plant biodiversity information for NEON plots}
\usage{
npe_summary(
  neon_div_object,
  scale = "plot",
  trace_cover = 0.5,
  timescale = "annual",
  betadiversity = FALSE,
  families = NA
)
}
\arguments{
\item{neon_div_object}{the raw vegan::diversity data downloaded using
neonPlantEcology::download_plant_div() or #' the function
neonUtilities::loadByProduct() with the dpID arguement set to "DP1.10058.001".}

\item{scale}{what level of aggregation? This can be "1m", "10m", "100m",
"plot" or "site". "plot" is the default.}

\item{trace_cover}{cover value for subplots where only occupancy was recorded}

\item{timescale}{by default npe_summary groups everything by year.
The user may set this argument to "all" to have the function aggregate the years
together and then calculate diversity and cover indexes, or "subannual" for bout-level.}

\item{betadiversity}{If evaluating at the plot or site level, should beta
diversity (turnover and nestedness) be calculated. If scale = plot, it will
calculate betadiversity within each plot, using the combined species
presences within the 1 and 10 m subplots, and so it's calcuated from 8 subplots
before 2020, 6 after. if scale = site, it calculates the betadiversity between
plots.}

\item{families}{Which specific families should the metrics be calculated for?
This can be a concatenated vector if the user want more than one family.}
}
\value{
a data frame of higher-level summary information. Number of species,
Shannon-Weiner alpha diversity, cover, relative cover, for all species together
and grouped by nativeStatusCode.
}
\description{
npe_summary calculates various biodiversity and cover indexes at the
plot or subplot scale at each timestep for each plot. Outputs a data frame
with number of species, percent cover, relative percent cover (relative to the cover of the other plants), and shannon
diversity, for natives, exotics, "notexotics", unknowns, and all species.
"notexotic" refers to all species with native or unknown origin status. Also
calculates all of these metrics for the families of your choice.
}
\examples{
data("D14")
plot_level <- neonPlantEcology::npe_summary(neon_div_object = D14, scale = "plot")
}
