% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.R
\name{gini}
\alias{gini}
\title{Gini coefficient}
\usage{
gini(input, byrow = FALSE)
}
\arguments{
\item{input}{A matrix where the Gini coefficient will be calculated on each column. Note that vector data must be converted to a single-column matrix.}

\item{byrow}{Defaults to FALSE. Set to TRUE to calculate the Gini coefficient of each row.}
}
\value{
A vector of the Gini coefficients of each column.
}
\description{
Takes a matrix and returns the Gini coefficient of each column.
}
\examples{
# Vectors are not supported. First convert to a single-column matrix.
sample_data <- runif(20, 0, 1)
gini(matrix(sample_data, ncol = 1))

# Multiple Gini coefficients can be calculated simultaneously
gini(matrix(sample_data, ncol = 2)) 

}
\references{
Gini, C. (1912). Variabilita e mutabilita. Reprinted in Memorie di metodologica statistica (Ed. Pizetti E, Salvemini, T). Rome: Libreria Eredi Virgilio Veschi.
}
