% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcutter.R
\name{nc_occ_probs}
\alias{nc_occ_probs}
\title{Compute the occurrence probabilities}
\usage{
nc_occ_probs(
  occ_matrix,
  R = 500,
  S = sum(occ_matrix) * 10,
  mc.cores = getOption("mc.cores", 1L),
  n_batches = ceiling(R/30),
  verbose = FALSE
)
}
\arguments{
\item{occ_matrix}{The original co-occurrence matrix}

\item{R}{The number of randomisations to perform}

\item{S}{The number of successful edge swaps for each randomisation}

\item{mc.cores}{Number of parallel computations with mclapply() (set to 1 for
serial execution)}

\item{n_batches}{Split the computation into \code{n_batches} to avoid excessive
memory usage}

\item{verbose}{Print a status message when starting every new batch.}
}
\value{
The occurrence probability matrix.
}
\description{
Use the EdgeSwapping method to find the probability of occurrence of each
term in each container under the null hypothesis.
}
\examples{
# Generate an occurrence matrix.
m <- matrix(FALSE, 3, 9, dimnames = list(paste0("ID", 1:3), paste0("gene", 1:9)))
m[1, 1:3] <- m[2, c(1:2, 4:5)] <- m[3, c(1, 6:9)] <- TRUE
# Set the seed using the `rlecuyer` package
rlecuyer::.lec.SetPackageSeed(1:6)
# Compute the occurrence probabilities.
occ_probs <- nc_occ_probs(m, R = 20, S = 50)
# Using `n_batches=1` can speed up the computations at the cost of more RAM.
occ_probs <- nc_occ_probs(m, R = 20, n_batches = 1, mc.cores = 1)

}
