% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dyad_var.R
\name{get_dyad_var}
\alias{get_dyad_var}
\title{Get Dyad Variables}
\usage{
get_dyad_var(var, type = "att")
}
\arguments{
\item{var}{variable vector (actor attribute) or adjacency matrix (ties)
to be transformed to a dyad variable.}

\item{type}{either 'att' for actor attribute (default) or 'tie' for relations.}
}
\value{
Dataframe with three columns:
first two columns show the vertex pairs \code{u} and \code{v} where \code{u<v} ,
and the third column gives the value of the transformed dyadic variable \code{var}.
}
\description{
Transforms vertex variables or observed directed/undirected ties
into dyad variables.
}
\details{
Dyad variables are given as pairs of incident vertex variables
or actor attributes. Here, unique pairs of original attribute values
constitute the outcome space. Note that the actor  attributes need
to be categorical with finite range spaces. For example, binary
attribute yields outcome space (0,0), (0,1), (1,0), (1,1) coded as (0),(1),(2),(3).
Warning message is shown if actor attribute has too many unique outcomes
as it will yield too many possible outcomes once converted in to a dyad variable.
\cr

For directed relations, pairs of indicators from the adjacency matrix constitute
the four outcomes representing possible combinations of sending and receiving ties:
(0,0), (0,1), (1,0), (1,1) coded as (0),(1),(2),(3).
\cr

For undirected relations, an indicator variable which is directly read from the
adjacency matrix represents the dyadic variable.
\cr
}
\examples{
# use internal data set
data(lawdata)
adj.advice <- lawdata[[1]]
adj.cowork <- lawdata[[3]]
df.att <- lawdata[[4]]

# three steps of data editing of attribute dataframe:
# 1. categorize variables 'years' and 'age' based on
# approximately three equally size groups (values based on cdf)
# 2. make sure all outcomes start from the value 0 (optional)
# 3. remove variable 'senior' as it consists of only unique values (thus redundant)
df.att.ed <- data.frame(
    status = df.att$status,
    gender = df.att$gender,
    office = df.att$office - 1,
    years = ifelse(df.att$years <= 3, 0,
        ifelse(df.att$years <= 13, 1, 2)
    ),
    age = ifelse(df.att$age <= 35, 0,
        ifelse(df.att$age <= 45, 1, 2)
    ),
    practice = df.att$practice,
    lawschool = df.att$lawschool - 1
)

# actor attribute converted to dyad variable
dyad.gend <- get_dyad_var(df.att.ed$gender, "att")

# directed tie converted to dyad variable
dyad.adv <- get_dyad_var(adj.advice, "tie")

# undirected tie converted to dyad variable
dyad.cwk <- get_dyad_var(adj.cowork, "tie")
}
\references{
Frank, O., & Shafie, T. (2016). Multivariate entropy analysis of network data.
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie Sociologique}, 129(1), 45-63.
}
\seealso{
\code{\link{get_triad_var}}
}
\author{
Termeh Shafie
}
