% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_entropy.R
\name{joint_entropy}
\alias{joint_entropy}
\title{Joint Entropy}
\usage{
joint_entropy(dat, dec = 3)
}
\arguments{
\item{dat}{dataframe with rows as observations and columns as variables.
Variables must all be observed or transformed categorical with finite range spaces.}

\item{dec}{the precision given in number of decimals for which
the frequency distribution of unique entropy values is created. Default is 3.}
}
\value{
List with
\item{matrix}{an upper triangular joint entropy matrix (univariate entropies in the diagonal).}
\item{freq}{a dataframe giving the frequency distributions of unique joint entropy values.}
}
\description{
Computes the joint entropies between all pairs of (discrete)
variables in a multivariate data set.
}
\details{
The joint entropy \emph{J(X,Y)} of discrete variables \emph{X} and \emph{Y}
is a measure of dependence or association between them, defined as
\cr

\emph{J(X,Y) = H(X) + H(Y) - H(X,Y)}.
\cr

Two variables are independent if their joint entropy,
i.e. their mutual information, is equal to zero.
The frequency distributions can be used to decide upon convenient thresholds for
constructing association graphs.
}
\examples{
# use internal data set
data(lawdata)
df.att <- lawdata[[4]]

# three steps of data editing:
# 1. categorize variables 'years' and 'age' based on
# approximately three equally size groups (values based on cdf)
# 2. make sure all outcomes start from the value 0 (optional)
# 3. remove variable 'senior' as it consists of only unique values (thus redundant)
df.att.ed <- data.frame(
    status = df.att$status,
    gender = df.att$gender,
    office = df.att$office - 1,
    years = ifelse(df.att$years <= 3, 0,
        ifelse(df.att$years <= 13, 1, 2)
    ),
    age = ifelse(df.att$age <= 35, 0,
        ifelse(df.att$age <= 45, 1, 2)
    ),
    practice = df.att$practice,
    lawschool = df.att$lawschool - 1
)

# calculate joint entropies
J <- joint_entropy(df.att.ed)
# joint entropy matrix
J$matrix
# frequency distribution of joint entropy values
J$freq
}
\references{
Frank, O., & Shafie, T. (2016). Multivariate entropy analysis of network data.
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie Sociologique}, 129(1), 45-63.
}
\seealso{
\code{\link{assoc_graph}}, \code{\link{entropy_bivar}}
}
\author{
Termeh Shafie
}
