% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Diagnosis plots to evaluate a fitted \code{neuralGAM} model.}
\usage{
diagnose(
  object,
  data = NULL,
  response = NULL,
  qq_method = c("uniform", "simulate", "normal"),
  n_uniform = 1000,
  n_simulate = 200,
  residual_type = c("deviance", "pearson", "quantile"),
  level = 0.95,
  point_col = "steelblue",
  point_alpha = 0.5,
  hist_bins = 30
)
}
\arguments{
\item{object}{A fitted \code{neuralGAM} model.}

\item{data}{Optional \code{data.frame} for out-of-sample evaluation. If
supplied, \code{response} must name the response column.}

\item{response}{Character scalar giving the response variable name in
\code{data} (required when \code{data} is provided).}

\item{qq_method}{Character; one of \code{"uniform"}, \code{"simulate"}, or
\code{"normal"} for the QQ reference. See Details.}

\item{n_uniform}{Integer; number of \eqn{U(0,1)} replicates for
\code{qq_method = "uniform"}.}

\item{n_simulate}{Integer; number of simulated datasets for
\code{qq_method = "simulate"} (also controls the QQ bands).}

\item{residual_type}{One of \code{"deviance"}, \code{"pearson"}, or
\code{"quantile"}. Quantile (Dunn-Smyth) residuals are recommended for
discrete families (binomial/poisson) because they are continuous and
approximately standard normal under the fitted model, improving QQ
diagnostics.}

\item{level}{Numeric in (0,1); coverage level for the QQ bands when
\code{qq_method = "simulate"}.}

\item{point_col}{Character; colour for points in scatter/histogram panels.}

\item{point_alpha}{Numeric in (0,1); point transparency.}

\item{hist_bins}{Integer; number of bins in the histogram.}
}
\value{
A \pkg{patchwork} object combining four \pkg{ggplot2} plots. You can
print it, add titles/themes, or extract individual panels if needed.
}
\description{
Produce a 2x2 diagnostic panel for a fitted \code{neuralGAM} model, mirroring
the layout of \pkg{gratia}'s \code{appraise()} for \pkg{mgcv} GAMs:
(top-left) a QQ plot of residuals with optional simulation envelope,
(top-right) a histogram of residuals,
(bottom-left) residuals vs linear predictor \eqn{\eta}, and
(bottom-right) observed vs fitted values on the response scale.
}
\details{
The function uses \code{predict.neuralGAM()} to obtain the linear
predictor (\code{type = "link"}) and the fitted mean on the response scale
(\code{type = "response"}). Residuals are computed internally for supported
families; by default we use \emph{deviance residuals}:
\itemize{
\item \strong{Gaussian}: \eqn{r_i = y_i - \hat{\mu}_i}.
\item \strong{Binomial}: \eqn{r_i = \mathrm{sign}(y_i-\hat{\mu}_i)\,
        \sqrt{2 w_i \{ y_i \log(y_i/\hat{\mu}_i) + (1-y_i)\log[(1-y_i)/(1-\hat{\mu}_i)] \}}}, with optional per-observation weights \eqn{w_i} (e.g., trials for proportions).
\item \strong{Poisson}: \eqn{r_i = \mathrm{sign}(y_i-\hat{\mu}_i)\,
        \sqrt{2 w_i \{ y_i \log(y_i/\hat{\mu}_i) - (y_i-\hat{\mu}_i) \}}}, adopting the convention \eqn{y_i \log(y_i/\hat{\mu}_i)=0} when \eqn{y_i=0}.
}

For Gaussian models, these plots diagnose symmetry, tail behaviour, and
mean/variance misfit similar to standard GLM/GAM diagnostics. For non-Gaussian
families (Binomial, Poisson), interpret shapes on the \emph{deviance} scale,
which is approximately normal under a well-specified model. For discrete data,
\emph{randomized quantile (Dunn-Smyth)} residuals are also available and often
yield smoother QQ behaviour.

\strong{QQ reference methods.}
\code{qq_method} controls how theoretical quantiles are generated (as in \pkg{gratia}):
\itemize{
\item \code{"uniform"} (default): draw \eqn{U(0,1)} and map through the inverse CDF of the fitted response distribution
at each observation; convert to residuals and average the sorted curves over \code{n_uniform} draws.
Fast and respects the mean-variance relationship.
\item \code{"simulate"}: simulate \code{n_simulate} datasets from the fitted model at the observed covariates, compute residuals, and average the sorted curves; also provides pointwise \code{level} bands on the QQ plot.
\item \code{"normal"}: use standard normal quantiles; a fallback when a suitable RNG or inverse CDF is unavailable.
}

For Poisson models, include offsets for exposure in the linear predictor
(e.g., \code{log(E)}). The QQ methods use \eqn{\hat{\mu}_i} with
\code{qpois}/\code{rpois} for \code{"uniform"}/\code{"simulate"}, respectively.
}
\section{Dependencies}{

Requires \pkg{ggplot2} and \pkg{patchwork}.
}

\references{
Augustin, N.H., Sauleau, E.A., Wood, S.N. (2012). On quantile-quantile plots
for generalized linear models. \emph{Computational Statistics & Data Analysis},
\strong{56}, 2404-2409. https://doi.org/10.1016/j.csda.2012.01.026

Dunn, P.K., Smyth, G.K. (1996). Randomized quantile residuals.
\emph{Journal of Computational and Graphical Statistics}, \strong{5}(3), 236-244.
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
