% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMetricsExample.R
\docType{data}
\name{calculateMetricsExample}
\alias{calculateMetricsExample}
\title{Precomputed Inputs for SCC vs. SPM Performance Evaluation}
\format{
A set of four objects:
\describe{
  \item{\code{detectedSCC}}{Data frame of SCC-detected coordinates (from \code{\link{getPoints}}).}
  \item{\code{detectedSPM}}{Data frame of SPM-detected coordinates (from \code{\link{getSPMbinary}}).}
  \item{\code{trueROI}}{Ground truth ROI voxel data (from \code{\link{processROIs}}).}
  \item{\code{totalCoords}}{List with full image grid dimensions (from \code{\link{getDimensions}}).}
}
}
\source{
Simulated PET neuroimaging study for testing SCC and SPM detection accuracy.
}
\usage{
data("calculateMetricsExample")
}
\description{
A dataset containing all necessary inputs for demonstrating \code{\link{calculateMetrics}}.
It enables reproducible and fast example code that compares SCC-detected and SPM-detected
points against a known ground truth ROI.

These inputs were generated using sample PET and ROI files included in the \code{neuroSCC} package.
}
\seealso{
\code{\link{calculateMetrics}}, \code{\link{getPoints}}, \code{\link{getSPMbinary}},
         \code{\link{processROIs}}, \code{\link{getDimensions}}
}
\keyword{datasets}
