% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustervol.R, R/neurovol.R, R/roi.R,
%   R/sparse_neurovec.R
\name{as.dense,ClusteredNeuroVol-method}
\alias{as.dense,ClusteredNeuroVol-method}
\alias{as.dense,SparseNeuroVol-method}
\alias{as.dense,ROIVol-method}
\alias{as.dense,SparseNeuroVec-method}
\title{Coerce SparseNeuroVol to DenseNeuroVol}
\usage{
\S4method{as.dense}{ClusteredNeuroVol}(x)

\S4method{as.dense}{SparseNeuroVol}(x)

\S4method{as.dense}{ROIVol}(x)

\S4method{as.dense}{SparseNeuroVec}(x)
}
\arguments{
\item{x}{An object of class \code{ROIVol} to be coerced to a \code{DenseNeuroVol}.}
}
\value{
A \code{\linkS4class{NeuroVol}} object representing the dense version of the clustered volume.

A DenseNeuroVol with identical spatial dimensions and values expanded
  from the sparse representation.

A \code{DenseNeuroVol} object obtained by coercing the \code{ROIVol} object.
}
\description{
Convert a sparse volumetric image to a dense representation with the same
spatial geometry. Non-zero values stored in the sparse vector are placed at
their corresponding linear indices in the dense array; all other voxels are 0.

This function provides a method to coerce an object of class \code{ROIVol} to a \code{DenseNeuroVol} using the \code{as.dense} method.
}
