% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/mapped_neurovec.R,
%   R/neurovec.R, R/sparse_neurovec.R
\name{as_mmap}
\alias{as_mmap}
\alias{as_mmap-methods}
\alias{as_mmap,MappedNeuroVec-method}
\alias{as_mmap,FileBackedNeuroVec-method}
\alias{as_mmap,NeuroVec-method}
\alias{as_mmap,SparseNeuroVec-method}
\title{Convert a NeuroVec to a memory-mapped representation}
\usage{
as_mmap(x, file = NULL, ...)

\S4method{as_mmap}{MappedNeuroVec}(x, file = NULL, ...)

\S4method{as_mmap}{FileBackedNeuroVec}(x, file = NULL, ...)

\S4method{as_mmap}{NeuroVec}(x, file = NULL, data_type = "FLOAT", overwrite = FALSE, ...)

\S4method{as_mmap}{SparseNeuroVec}(x, file = NULL, data_type = "FLOAT", overwrite = FALSE, ...)
}
\arguments{
\item{x}{A neuroimaging vector (\code{NeuroVec}, \code{MappedNeuroVec},
or \code{FileBackedNeuroVec}).}

\item{file}{Optional output file name. If \code{NULL}, a temporary file
with extension \code{.nii} is created.}

\item{...}{Additional arguments passed to methods (e.g. \code{data_type},
\code{overwrite}).}

\item{data_type}{Character string specifying the output data type for the
NIfTI file. Should be one of: "BINARY", "UBYTE", "SHORT", "INT", "FLOAT",
"DOUBLE". Default is "FLOAT".}

\item{overwrite}{Logical; if \code{TRUE}, overwrite an existing file at the
specified path. Default is \code{FALSE}.}
}
\value{
A \code{\linkS4class{MappedNeuroVec}} (or \code{x} itself if already
  memory-mapped).

A \code{\linkS4class{MappedNeuroVec}} (or \code{x} itself if it is
  already memory-mapped).
}
\description{
Generic for converting neuroimaging vectors to a memory-mapped
\code{\linkS4class{MappedNeuroVec}} on disk (when possible).

Methods for the \code{\link{as_mmap}} generic, which convert various
neuroimaging vector types to a \code{\linkS4class{MappedNeuroVec}} backed
by an on-disk NIfTI file.
}
