% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/SparseBrainVector.R, R/BrainVector.R, R/BrainVolume.R
\docType{methods}
\name{concat}
\alias{concat}
\alias{concat,BrainVector,BrainVector-method}
\alias{concat,BrainVector,BrainVolume-method}
\alias{concat,BrainVolume,BrainVector-method}
\alias{concat,DenseBrainVolume,DenseBrainVolume-method}
\alias{concat,SparseBrainVector,SparseBrainVector-method}
\title{Concatenate two objects}
\usage{
concat(x, y, ...)

\S4method{concat}{SparseBrainVector,SparseBrainVector}(x, y, ...)

\S4method{concat}{BrainVector,BrainVolume}(x, y, ...)

\S4method{concat}{BrainVolume,BrainVector}(x, y, ...)

\S4method{concat}{BrainVector,BrainVector}(x, y, ...)

\S4method{concat}{DenseBrainVolume,DenseBrainVolume}(x, y, ...)
}
\arguments{
\item{x}{the first object, typically \code{BrainVolume} or \code{BrainVector}}

\item{y}{the second object, typically \code{BrainVolume} or \code{BrainVector}}

\item{...}{additional objects}
}
\description{
Concatenate two objects
}
\details{
The \code{x} and \code{y} images must have compatible dimensions. a \code{BrainVolume} can be concatenated to \code{BrainVector}, and vice versa. See examples.
}
\note{
dimensions of x and y must be equal
}
\examples{
bv1 <- BrainVolume(rep(1,1000), BrainSpace(c(10,10,10), c(1,1,1)))
bv2 <- BrainVolume(rep(2,1000), BrainSpace(c(10,10,10), c(1,1,1)))
bv3 <- concat(bv1,bv2)
inherits(bv3, "BrainVector")

bv4 <- concat(bv3, bv1)
dim(bv4)[4] == 3
bv5 <- concat(bv1, bv3)
dim(bv4)[4] == 3

bv6 <- concat(bv4,bv5)
dim(bv6)[4] == 6

}

