% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLd1.R
\name{dLd1}
\alias{dLd1}
\alias{ddLd1}
\alias{pdLd1}
\alias{qdLd1}
\alias{rdLd1}
\title{Discrete Lindley Distribution}
\usage{
ddLd1(x, theta, log = FALSE)

pdLd1(q, theta, lower.tail = TRUE, log.p = FALSE)

qdLd1(p, theta, lower.tail = TRUE)

rdLd1(n, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{ddLd1} gives the density, \code{pdLd1} gives the distribution
function, \code{qdLd1} gives the quantile function and \code{rdLd1} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the discrete Lindley distribution.
}
\details{
The Discrete Lindley distribution with a parameter \eqn{\theta}, has density
\deqn{f\left( x\right) =\frac{\lambda ^{x}}{1-\log \lambda }
\left( \lambda \log\lambda +\left( 1-\lambda \right)
\left( 1-\log \lambda^{x+1}\right)\right), }
where
\deqn{x=0,1,...,~\theta >0~and~\lambda =e^{-\theta }.}
}
\examples{
library(new.dist)
ddLd1(1,theta=2)
pdLd1(2,theta=1)
qdLd1(.993,theta=2)
rdLd1(10,theta=1)
}
\references{
Gómez-Déniz, E. ve Calderín-Ojeda, E., 2011,
\emph{The discrete Lindley distribution: properties and applications}.Journal of
statistical computation and simulation, 81 (11), 1405-1416.
}
